/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import java.util.Optional;
import org.mule.datasense.api.ApplicationResolutionScope;
import org.mule.datasense.api.ComponentResolutionScope;
import org.mule.datasense.api.ConfigResolutionScope;
import org.mule.datasense.api.DataSenseResolutionScope;
import org.mule.datasense.impl.phases.builder.ApplicationResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.ComponentModelClassifier;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.ComponentResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.ConfigResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.DataSenseResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.datasense.impl.util.TreeLogSupport;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;

public class MuleAstParserContext {
    private final TreeLogSupport treeLogSupport;
    private final ComponentModelClassifier componentModelClassifier;
    private final DataSenseResolutionScopeStrategy dataSenseResolutionScopeStrategy;
    private final TypeResolverRegistry typeResolverRegistry;

    public MuleAstParserContext(ComponentModelClassifier componentModelClassifier) {
        this(componentModelClassifier, null, null);
    }

    public MuleAstParserContext(ComponentModelClassifier componentModelClassifier, DataSenseResolutionScope dataSenseResolutionScope, TypeResolverRegistry typeResolverRegistry) {
        this.componentModelClassifier = componentModelClassifier;
        this.dataSenseResolutionScopeStrategy = MuleAstParserContext.createDataSenseResolutionScopeStrategy(dataSenseResolutionScope);
        this.typeResolverRegistry = typeResolverRegistry;
        this.treeLogSupport = new TreeLogSupport();
    }

    public Optional<DataSenseResolutionScopeStrategy> getDataSenseResolutionScopeStrategy() {
        return Optional.ofNullable(this.dataSenseResolutionScopeStrategy);
    }

    TreeLogSupport astlogger() {
        return this.treeLogSupport;
    }

    void enter(ComponentModel componentModel) {
        this.astlogger().enter(componentModel.getIdentifier().toString());
    }

    void exit(ComponentModel componentModel) {
        this.astlogger().exit(componentModel.getIdentifier().toString());
    }

    public Optional<ComponentModelType> getComponentModelType(ComponentModel componentModel) {
        return this.componentModelClassifier.getComponentModelType(componentModel);
    }

    public Optional<MuleAstParseProvider> getParseProvider(ComponentModel componentModel) {
        return this.typeResolverRegistry.get(ComponentIdentifierUtils.createFromComponentModel(componentModel)).flatMap(TypeResolver::getParseProvider);
    }

    private static DataSenseResolutionScopeStrategy createDataSenseResolutionScopeStrategy(DataSenseResolutionScope dataSenseResolutionScope) {
        if (dataSenseResolutionScope == null) {
            return null;
        }
        if (dataSenseResolutionScope instanceof ApplicationResolutionScope) {
            return new ApplicationResolutionScopeStrategy((ApplicationResolutionScope)dataSenseResolutionScope);
        }
        if (dataSenseResolutionScope instanceof ConfigResolutionScope) {
            return new ConfigResolutionScopeStrategy((ConfigResolutionScope)dataSenseResolutionScope);
        }
        if (dataSenseResolutionScope instanceof ComponentResolutionScope) {
            return new ComponentResolutionScopeStrategy((ComponentResolutionScope)dataSenseResolutionScope);
        }
        throw new IllegalArgumentException(String.format("Unknown resolution scope class %s.", dataSenseResolutionScope.getClass()));
    }
}

