/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import java.util.Iterator;
import java.util.stream.Collectors;
import org.mule.datasense.declarations.model.MessageProcessorTypeDeclaration;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MessageProcessorTypeDeclarationAnnotation;
import org.mule.datasense.impl.model.annotations.MessageSourceRegionContextAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.annotators.AnnotatorsRegistry;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.message.MuleEventMetadataType;

public class AnnotatingMuleAstVisitor
implements AstNodeVisitor<AnnotatingMuleAstVisitorContext> {
    private final AnnotatorsRegistry annotatorsRegistry;

    public AnnotatingMuleAstVisitor(AnnotatorsRegistry annotatorsRegistry) {
        this.annotatorsRegistry = annotatorsRegistry;
    }

    public AnnotatorsRegistry getAnnotatorsRegistry() {
        return this.annotatorsRegistry;
    }

    @Override
    public Object visit(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext visitorContext) {
        visitorContext.logger().enter(messageProcessorNode.getName());
        this.getAnnotatorsRegistry().annotate(messageProcessorNode, visitorContext);
        boolean root = messageProcessorNode.isRootMessageProcessorNode();
        if (root) {
            MessageProcessorNode child2;
            Iterator messageProcessorNodeIterator = messageProcessorNode.getMessageProcessorNodes().collect(Collectors.toList()).iterator();
            if (messageProcessorNodeIterator.hasNext()) {
                child2 = (MessageProcessorNode)messageProcessorNodeIterator.next();
                visitorContext.annotate(new MessageSourceRegionContextAnnotation());
                this.annotate(child2, visitorContext);
                visitorContext.deannotate(MessageSourceRegionContextAnnotation.class);
            }
            while (messageProcessorNodeIterator.hasNext()) {
                child2 = (MessageProcessorNode)messageProcessorNodeIterator.next();
                this.annotate(child2, visitorContext);
            }
        } else {
            messageProcessorNode.getMessageProcessorNodes().forEach(child -> this.annotate((AstNode)child, visitorContext));
        }
        visitorContext.logger().exit(messageProcessorNode.getName());
        return null;
    }

    @Override
    public Object visit(MuleApplicationNode muleApplicationNode, AnnotatingMuleAstVisitorContext visitorContext) {
        visitorContext.logger().enter(muleApplicationNode.getName());
        visitorContext.annotate(new MuleApplicationAnnotation(muleApplicationNode));
        muleApplicationNode.getMuleFlowNodes().forEach(muleFlowNode -> this.annotate((AstNode)muleFlowNode, visitorContext));
        visitorContext.deannotate(MuleApplicationAnnotation.class);
        visitorContext.logger().exit(muleApplicationNode.getName());
        return null;
    }

    @Override
    public Object visit(MuleFlowNode muleFlowNode, AnnotatingMuleAstVisitorContext visitorContext) {
        visitorContext.logger().enter(muleFlowNode.getName());
        visitorContext.getDataSenseProviderResolver().findMessageProcessorTypeDeclaration(muleFlowNode.getComponentModel()).ifPresent(messageProcessorTypeDeclaration -> {
            FunctionType functionType = messageProcessorTypeDeclaration.getFunctionType();
            functionType.getParameters().stream().map(FunctionParameter::getType).filter(metadataType -> metadataType instanceof MuleEventMetadataType).map(metadataType -> TypeUtils.asEventType((MuleEventMetadataType)metadataType)).findFirst().ifPresent(eventType -> muleFlowNode.annotate(new UsesTypeAnnotation((EventType)eventType)));
            functionType.getReturnType().filter(metadataType -> metadataType instanceof MuleEventMetadataType).map(metadataType -> TypeUtils.asEventType((MuleEventMetadataType)metadataType)).ifPresent(eventType -> muleFlowNode.annotate(new DefinesTypeAnnotation((EventType)eventType)));
            muleFlowNode.annotate(new MessageProcessorTypeDeclarationAnnotation((MessageProcessorTypeDeclaration)messageProcessorTypeDeclaration));
        });
        visitorContext.annotate(new MuleFlowAnnotation(muleFlowNode));
        muleFlowNode.getRootMessageProcessorNode().ifPresent(messageProcessorNode -> this.annotate((AstNode)messageProcessorNode, visitorContext));
        visitorContext.deannotate(MuleFlowAnnotation.class);
        visitorContext.logger().exit(muleFlowNode.getName());
        return null;
    }

    public void annotate(AstNode astNode, DataSenseProviderResolver dataSenseProviderResolver, AstNotification astNotification) {
        this.annotate(astNode, new AnnotatingMuleAstVisitorContext(astNotification, dataSenseProviderResolver));
    }

    public void annotate(AstNode astNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        astNode.accept(this, annotatingMuleAstVisitorContext);
    }
}

