/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.MessageMetadataType;
import org.mule.metadata.message.MessageMetadataTypeBuilder;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;

public class CollectionSplitterTypeResolver
extends SingleNodeTypeResolver {
    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    private EventType getUsesEventType(EventType inputEventType) {
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        MessageMetadataTypeBuilder defaultMessageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
        defaultMessageMetadataTypeBuilder.payload().arrayType().of().anyType();
        muleEventMetadataTypeBuilder.message((MessageMetadataType)TypeUtils.override((MetadataType)defaultMessageMetadataTypeBuilder.build(), TypeUtils.getMessageMetadataType(inputEventType).orElse(null)));
        return TypeUtils.asEventType(muleEventMetadataTypeBuilder.build());
    }

    private EventType getDefinesEventType(EventType usesEventType) {
        MessageMetadataType usesMessageMetadataType = TypeUtils.getMessageMetadataType(usesEventType).orElseThrow(IllegalArgumentException::new);
        MetadataType payloadType = usesMessageMetadataType.getPayloadType().filter(metadataType -> metadataType instanceof ArrayType).map(metadataType -> ((ArrayType)metadataType).getType()).orElse((MetadataType)TypesHelper.getTypeBuilder().anyType().build());
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        muleEventMetadataTypeBuilder.message((MessageMetadataType)TypeUtils.override((MetadataType)usesMessageMetadataType, (MetadataType)new MessageMetadataTypeBuilder().payload(payloadType).build()));
        return TypeUtils.asEventType(muleEventMetadataTypeBuilder.build());
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        EventType usesEventType = this.getUsesEventType(inputEventType);
        messageProcessorNode.annotate(new UsesTypeAnnotation(usesEventType));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(this.getDefinesEventType(usesEventType)));
        return inputEventType;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

