/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.List;
import java.util.Optional;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.PipedChainTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;

public class FlowTypeResolver
extends PipedChainTypeResolver {
    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    @Override
    public Optional<MuleAstParseProvider> getParseProvider() {
        return Optional.of((componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders, muleAstParserContext) -> this.generateAst(componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders));
    }

    private Optional<AstNodeBuilder> generateAst(ComponentIdentifier componentIdentifier, ComponentModel componentModel, ComponentModelType componentModelType, List<MessageProcessorNodeBuilder> messageProcessorNodeBuilders) {
        MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
        messageProcessorNodeBuilder.config(componentModel);
        messageProcessorNodeBuilder.componentModelType(componentModelType);
        messageProcessorNodeBuilder.messageProcessor(DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_SCOPE_IN, m -> {
            m.config(componentModel);
            m.synthetic();
        });
        messageProcessorNodeBuilders.forEach(messageProcessorNodeBuilder::messageProcessor);
        messageProcessorNodeBuilder.messageProcessor(DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_SCOPE_OUT, m -> {
            m.config(componentModel);
            m.synthetic();
        });
        return Optional.of(messageProcessorNodeBuilder);
    }

    public static class ScopeOut
    extends SingleNodeTypeResolver {
        @Override
        protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
            EventType eventType = visitorContext.getAnnotation(MuleFlowAnnotation.class).map(MuleFlowAnnotation::getMuleFlowNode).flatMap(muleFlowNode -> muleFlowNode.getAnnotation(DefinesTypeAnnotation.class)).map(definesTypeAnnotation -> definesTypeAnnotation.getDefinesEventType()).orElse(new EventType());
            messageProcessorNode.annotate(new UsesTypeAnnotation(eventType));
            return inputEventType;
        }

        @Override
        protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
            return true;
        }
    }

    public static class ScopeIn
    extends SingleNodeTypeResolver {
        @Override
        protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
            inputEventType = visitorContext.getAnnotation(MuleFlowAnnotation.class).map(MuleFlowAnnotation::getMuleFlowNode).flatMap(muleFlowNode -> muleFlowNode.getAnnotation(UsesTypeAnnotation.class)).map(usesTypeAnnotation -> usesTypeAnnotation.getUsesEventType()).orElse(inputEventType);
            messageProcessorNode.annotate(new DefinesTypeAnnotation(inputEventType));
            return inputEventType;
        }

        @Override
        protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
            return true;
        }
    }
}

