/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.VoidOperationAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.InputArgument;
import org.mule.datasense.impl.model.operation.InputParameter;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.MessageMetadataType;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.el.ExpressionLanguageMetadataTypeResolver;

public class OperationCallTypeResolver
extends SingleNodeTypeResolver {
    @Override
    protected ExpressionLanguageMetadataTypeResolver.MessageCallback createMessageCallback(final AstNotification astNotification, final AstNodeLocation astNodeLocation) {
        return new ExpressionLanguageMetadataTypeResolver.MessageCallback(){

            public void warning(String message) {
                astNotification.reportWarning(astNodeLocation, NotificationMessages.MSG_SCRIPTING_LANGUAGE_WARNING("", message));
            }

            public void error(String message) {
                astNotification.reportError(astNodeLocation, NotificationMessages.MSG_SCRIPTING_LANGUAGE_ERROR("", message));
            }
        };
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        Optional annotation = messageProcessorNode.getAnnotation(OperationCallAnnotation.class);
        if (annotation.isPresent()) {
            MetadataType returnType;
            OperationCallAnnotation operationCallAnnotation = (OperationCallAnnotation)annotation.get();
            OperationCall operationCall = operationCallAnnotation.getOperationCall();
            MuleEventMetadataTypeBuilder inferredMuleEventTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
            operationCall.getInputMappings().forEach(inputMapping -> {
                InputArgument inputArgument = inputMapping.getInputArgument();
                InputParameter inputParameter = inputMapping.getInputParameter();
                if (inputArgument.getExpression() != null) {
                    ExpressionLanguageUtils.resolveInputEventType(inputArgument.getExpression(), visitorContext.getExpressionLanguageMetadataTypeResolver(), inputParameter.getMetadataType(), inferredMuleEventTypeBuilder, this.createMessageCallback(visitorContext.getAstNotification(), messageProcessorNode.getAstNodeLocation()));
                }
            });
            MuleEventMetadataType inferredInputMuleEventType = inferredMuleEventTypeBuilder.build();
            messageProcessorNode.annotate(new UsesTypeAnnotation(TypeUtils.asEventType(inferredInputMuleEventType)));
            EventType outputEventType = inputEventType;
            if (!messageProcessorNode.isAnnotatedWith(VoidOperationAnnotation.class) && (returnType = operationCall.getReturnType()) instanceof MessageMetadataType) {
                MessageMetadataType returnMessageMetadataType = (MessageMetadataType)returnType;
                String target = operationCall.getTarget().orElse(null);
                outputEventType = target != null ? new EventType(Stream.of(new VarDecl(target, returnType))) : new EventType(TypeUtils.asVarDecls(returnMessageMetadataType, true));
                messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
            }
            return outputEventType;
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

