/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.HashSet;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ProcessorChainTypeResolver;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.MessageMetadataType;
import org.mule.metadata.message.MessageMetadataTypeBuilder;

public class ScatterGatherTypeResolver
extends ProcessorChainTypeResolver {
    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
        ObjectTypeBuilder objectTypeBuilder = messageMetadataTypeBuilder.payload().objectType();
        HashSet routeIds = new HashSet();
        messageProcessorNode.getMessageProcessorNodes().forEach(innerMessageProcessorNode -> {
            String routeId = (String)innerMessageProcessorNode.getComponentModel().getParameters().get("doc:id");
            if (routeId != null && !routeIds.contains(routeId)) {
                EventType eventType = typingMuleAstVisitor.resolveType((AstNode)innerMessageProcessorNode, inputEventType, typingMuleAstVisitorContext);
                MetadataType routePayloadMetadataType = (MetadataType)TypeUtils.getMessageMetadataType(eventType).flatMap(MessageMetadataType::getPayloadType).orElse(TypesHelper.getTypeBuilder().anyType().build());
                MessageMetadataTypeBuilder routeMessageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
                routeMessageMetadataTypeBuilder.payload(routePayloadMetadataType);
                objectTypeBuilder.addField().key(routeId).value((MetadataType)routeMessageMetadataTypeBuilder.build());
                routeIds.add(routeId);
            }
        });
        EventType outputEventType = new EventType(TypeUtils.asVarDecls(messageMetadataTypeBuilder.build()));
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
        return outputEventType;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

