/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.ApplicationModelResolver;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;

public class DataSenseProviderResolver {
    private final DataSenseProvider dataSenseProvider;
    private final ApplicationModelResolver applicationModelResolver;
    private Map<String, ExtensionModel> extensionModelsByUri;

    public DataSenseProviderResolver(DataSenseProvider dataSenseProvider, ApplicationModelResolver applicationModelResolver) {
        this.dataSenseProvider = dataSenseProvider;
        this.applicationModelResolver = applicationModelResolver;
        this.extensionModelsByUri = new HashMap<String, ExtensionModel>();
        dataSenseProvider.getExtensions().stream().filter(Objects::nonNull).filter(extensionModel -> extensionModel.getXmlDslModel() != null).forEach(extensionModel -> this.extensionModelsByUri.put(extensionModel.getXmlDslModel().getNamespaceUri(), (ExtensionModel)extensionModel));
    }

    public DataSenseProvider getDataSenseProvider() {
        return this.dataSenseProvider;
    }

    public ApplicationModelResolver getApplicationModelResolver() {
        return this.applicationModelResolver;
    }

    private Optional<String> getConfigurationRef(ComponentModel componentModel) {
        return Optional.ofNullable(componentModel.getParameters().get("config-ref"));
    }

    public Optional<ExtensionModel> findExtensionModel(ComponentModel componentModel) {
        String namespaceUri = (String)componentModel.getCustomAttributes().get("NAMESPACE_URI");
        return Optional.ofNullable(this.extensionModelsByUri.get(namespaceUri));
    }

    private Optional<ConfigurationModel> getConfigurationModel(String configuration, ExtensionModel extensionModel) {
        Optional configurationModel = Optional.empty();
        Optional<ComponentModel> namedComponent = this.getApplicationModelResolver().getApplicationModel().findNamedComponent(configuration);
        if (namedComponent.isPresent()) {
            configurationModel = extensionModel.getConfigurationModel(namedComponent.get().getIdentifier().getName());
        }
        return configurationModel;
    }

    private Optional<? extends HasSourceModels> getHasSourceModels(ComponentModel componentModel, ExtensionModel extensionModel) {
        Optional<String> configurationRef = this.getConfigurationRef(componentModel);
        return configurationRef.isPresent() ? this.getConfigurationModel(configurationRef.get(), extensionModel) : Optional.of(extensionModel);
    }

    public Optional<SourceModel> resolveSourceModel(ComponentModel componentModel) {
        ExtensionModel extensionModel;
        Optional<? extends HasSourceModels> hasSourceModels;
        Optional result = Optional.empty();
        Optional<ExtensionModel> optionalExtensionModel = this.findExtensionModel(componentModel);
        if (optionalExtensionModel.isPresent() && (hasSourceModels = this.getHasSourceModels(componentModel, extensionModel = optionalExtensionModel.get())).isPresent()) {
            result = hasSourceModels.get().getSourceModel(componentModel.getIdentifier().getName());
        }
        return result;
    }

    private Optional<? extends HasOperationModels> getHasOperationModels(ComponentModel componentModel, ExtensionModel extensionModel) {
        Optional<String> configurationRef = this.getConfigurationRef(componentModel);
        return configurationRef.isPresent() ? this.getConfigurationModel(configurationRef.get(), extensionModel) : Optional.of(extensionModel);
    }

    public Optional<OperationModel> resolveOperationModel(ComponentModel componentModel) {
        ExtensionModel extensionModel;
        Optional<? extends HasOperationModels> hasOperationModels;
        Optional result = Optional.empty();
        Optional<ExtensionModel> optionalExtensionModel = this.findExtensionModel(componentModel);
        if (optionalExtensionModel.isPresent() && (hasOperationModels = this.getHasOperationModels(componentModel, extensionModel = optionalExtensionModel.get())).isPresent()) {
            result = hasOperationModels.get().getOperationModel(componentModel.getIdentifier().getName());
        }
        return result;
    }
}

