/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import java.util.Optional;
import org.mule.datasense.api.AnalysisResult;
import org.mule.datasense.api.ComponentPath;
import org.mule.datasense.api.DataSense;
import org.mule.datasense.api.DataSenseInfo;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.extension.DataSenseModuleRegistry;
import org.mule.datasense.impl.ApplicationModelResolver;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.DefaultDataSenseInfo;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.annotators.AnnotatorsRegistry;
import org.mule.datasense.impl.phases.annotators.InfoAnnotator;
import org.mule.datasense.impl.phases.annotators.MuleFunctionTypeCustomizerAnnotator;
import org.mule.datasense.impl.phases.annotators.OperationCallAnnotator;
import org.mule.datasense.impl.phases.builder.ComponentModelClassifier;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MuleApplicationNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParser;
import org.mule.datasense.impl.phases.builder.MuleAstParserContext;
import org.mule.datasense.impl.phases.typing.AstTyping;
import org.mule.datasense.impl.phases.typing.resolver.FlowTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.OperationCallTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.PassThroughTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.ProcessorChainTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SetPayloadAttributesTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SetPayloadTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SetVariableTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TransformTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.tooling.MetadataQuery;
import org.mule.datasense.impl.tooling.MetadataQueryResult;
import org.mule.datasense.impl.tooling.NodeInfoQuery;
import org.mule.datasense.impl.tooling.TypeContextQuery;
import org.mule.datasense.impl.tooling.TypeContextQueryResult;
import org.mule.datasense.impl.tooling.TypeInfoQuery;
import org.mule.datasense.impl.tooling.TypeInfoQueryResult;
import org.mule.datasense.impl.tooling.TypedApplicationQuery;
import org.mule.datasense.impl.tooling.TypedApplicationQueryResult;
import org.mule.datasense.impl.util.AstUtils;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSense
implements DataSense {
    private static final transient Logger logger = LoggerFactory.getLogger(DefaultDataSense.class);
    private final DataSenseModuleRegistry dataSenseModuleRegistry = new DataSenseModuleRegistry();

    public static Logger getLogger() {
        return logger;
    }

    private DataSenseModuleRegistry getDataSenseModuleRegistry() {
        return this.dataSenseModuleRegistry;
    }

    private TypeResolverRegistry createTypeResolverRegistry() {
        TypeResolverRegistry typeResolverRegistry = new TypeResolverRegistry();
        typeResolverRegistry.register(ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "flow"), (TypeResolver)new FlowTypeResolver());
        typeResolverRegistry.register(ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "logger"), (TypeResolver)new PassThroughTypeResolver());
        typeResolverRegistry.register(ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "poll"), (TypeResolver)new PassThroughTypeResolver());
        typeResolverRegistry.register(ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "transform"), (TypeResolver)new TransformTypeResolver());
        typeResolverRegistry.register("operation-call", (TypeResolver)new OperationCallTypeResolver());
        typeResolverRegistry.register(ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "set-payload-attributes"), (TypeResolver)new SetPayloadAttributesTypeResolver());
        typeResolverRegistry.register(ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "set-payload"), (TypeResolver)new SetPayloadTypeResolver());
        typeResolverRegistry.register(ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "set-variable"), (TypeResolver)new SetVariableTypeResolver());
        typeResolverRegistry.register(ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "processor-chain"), (TypeResolver)new ProcessorChainTypeResolver());
        return typeResolverRegistry;
    }

    private AnnotatorsRegistry createAnnotatorsRegistry(DataSenseProviderResolver dataSenseProviderResolver) {
        AnnotatorsRegistry annotatorsRegistry = new AnnotatorsRegistry();
        annotatorsRegistry.add(new InfoAnnotator());
        annotatorsRegistry.add(new OperationCallAnnotator());
        annotatorsRegistry.add(new MuleFunctionTypeCustomizerAnnotator());
        return annotatorsRegistry;
    }

    private Optional<MuleApplicationNode> buildMuleApplication(final DataSenseProvider dataSenseProvider, final ApplicationModel applicationModel) {
        ComponentModel rootComponentModel = applicationModel.findRootComponentModel();
        MuleAstParser muleAstParser = new MuleAstParser();
        final TypeResolverRegistry typeResolverRegistry = this.createTypeResolverRegistry();
        MuleAstParserContext visitorContext = new MuleAstParserContext(new ComponentModelClassifier(){
            private DataSenseProviderResolver dataSenseProviderResolver;
            {
                this.dataSenseProviderResolver = new DataSenseProviderResolver(dataSenseProvider, new ApplicationModelResolver(applicationModel));
            }

            @Override
            public Optional<ComponentModelType> getComponentModelType(ComponentModel componentModel) {
                ComponentIdentifier identifier = ComponentIdentifierUtils.createFromComponentModel(componentModel);
                boolean messageProcessorType = typeResolverRegistry.get(identifier).isPresent() || this.dataSenseProviderResolver.resolveSourceModel(componentModel).isPresent() || this.dataSenseProviderResolver.resolveOperationModel(componentModel).isPresent();
                return messageProcessorType ? Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE) : Optional.empty();
            }
        });
        return muleAstParser.parse(rootComponentModel, visitorContext).filter(astNodeBuilder -> astNodeBuilder instanceof MuleApplicationNodeBuilder).map(astNodeBuilder -> ((MuleApplicationNodeBuilder)astNodeBuilder).build());
    }

    @Override
    public Optional<DataSenseInfo> resolve(ComponentPath componentPath, ApplicationModel applicationModel, DataSenseProvider dataSenseProvider) {
        logger.debug("resolving datasense info for component path " + componentPath);
        DataSenseModuleRegistry dataSenseModuleRegistry = this.getDataSenseModuleRegistry();
        logger.debug("listing modules...");
        dataSenseModuleRegistry.getDataSenseModules().forEach(dataSenseModule -> logger.debug("listing " + dataSenseModule.getName()));
        logger.debug("== PARSE " + StringUtils.repeat((String)"-", (int)10));
        Optional<MuleApplicationNode> muleApplicationNodeOptional = this.buildMuleApplication(dataSenseProvider, applicationModel);
        if (muleApplicationNodeOptional.isPresent()) {
            MuleApplicationNode muleApplicationNode = muleApplicationNodeOptional.get();
            AstNotification astNotification = new AstNotification();
            ApplicationModelResolver applicationModelResolver = new ApplicationModelResolver(applicationModel);
            DataSenseProviderResolver dataSenseProviderResolver = new DataSenseProviderResolver(dataSenseProvider, applicationModelResolver);
            AnnotatorsRegistry annotatorsRegistry = this.createAnnotatorsRegistry(dataSenseProviderResolver);
            this.process(muleApplicationNode, astNotification, dataSenseProviderResolver, annotatorsRegistry);
            return this.perform(new NodeInfoQuery(componentPath), muleApplicationNode).map(nodeInfoQueryResult -> {
                Optional<TypeInfoQueryResult> typeInfoQueryResult = this.perform(new TypeInfoQuery(componentPath), muleApplicationNode);
                Optional<TypeContextQueryResult> typeContextQueryResult = this.perform(new TypeContextQuery(componentPath), muleApplicationNode);
                Optional<MetadataQueryResult> metadataQueryResult = this.perform(new MetadataQuery(componentPath), muleApplicationNode);
                return new DefaultDataSenseInfo(metadataQueryResult.flatMap(MetadataQueryResult::getOperationModel).orElse(null), metadataQueryResult.flatMap(MetadataQueryResult::getSourceModel).orElse(null), (MetadataResult<ComponentMetadataDescriptor>)((MetadataResult)metadataQueryResult.flatMap(MetadataQueryResult::getComponentMetadataDescriptorMetadataResult).orElse(null)), typeInfoQueryResult.flatMap(TypeInfoQueryResult::getInput).orElse(null), typeInfoQueryResult.flatMap(TypeInfoQueryResult::getOutput).orElse(null), typeContextQueryResult.flatMap(TypeContextQueryResult::getIncoming).orElse(null), typeContextQueryResult.flatMap(TypeContextQueryResult::getExpected).orElse(null));
            });
        }
        logger.error("Failed build datasense model from application");
        return Optional.empty();
    }

    private void process(MuleApplicationNode muleApplicationNode, AstNotification astNotification, DataSenseProviderResolver dataSenseProviderResolver, AnnotatorsRegistry annotatorsRegistry) {
        logger.debug(StringUtils.repeat((String)"-", (int)10));
        AstUtils.dump(muleApplicationNode);
        AstTyping astTyping = new AstTyping(annotatorsRegistry, this.createTypeResolverRegistry());
        logger.debug("== ANNOTATE " + StringUtils.repeat((String)"-", (int)10));
        astTyping.annotate(muleApplicationNode, dataSenseProviderResolver, astNotification);
        logger.debug("== RESOLVE " + StringUtils.repeat((String)"-", (int)10));
        EventType eventType = this.createInitialEvent();
        astTyping.resolveTypes(muleApplicationNode, eventType, astNotification);
        logger.debug(StringUtils.repeat((String)"-", (int)10));
        AstUtils.dump(muleApplicationNode);
        logger.debug("== INCOMING " + StringUtils.repeat((String)"-", (int)10));
        astTyping.generateIncoming(muleApplicationNode, eventType, astNotification);
        logger.debug("== EXPECTED " + StringUtils.repeat((String)"-", (int)10));
        astTyping.generateExpected(muleApplicationNode, eventType, astNotification);
        logger.debug(StringUtils.repeat((String)"-", (int)10));
        AstUtils.dump(muleApplicationNode);
    }

    private EventType createInitialEvent() {
        return TypeUtils.createEventType((MetadataType)TypesHelper.getTypeBuilder().stringType().build());
    }

    @Override
    public AnalysisResult analyze(DataSenseProvider dataSenseProvider, ApplicationModel applicationModel) {
        return null;
    }

    private <T extends TypedApplicationQueryResult> Optional<T> perform(TypedApplicationQuery<T> typedApplicationQuery, MuleApplicationNode muleApplicationNode) {
        return typedApplicationQuery.perform(muleApplicationNode);
    }
}

