/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import java.util.LinkedList;
import java.util.List;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.runtime.api.i18n.I18nMessage;

public class AstNotification {
    private List<AstNotificationEntry> notifications = new LinkedList<AstNotificationEntry>();

    public void reportError(AstNodeLocation astNodeLocation, I18nMessage i18nMessage) {
        this.notifications.add(new AstNotificationEntry(NotificationType.ERROR, astNodeLocation, i18nMessage));
    }

    public void reportWarning(AstNodeLocation astNodeLocation, I18nMessage i18nMessage) {
        this.notifications.add(new AstNotificationEntry(NotificationType.WARNING, astNodeLocation, i18nMessage));
    }

    private boolean hasNotificationWithType(NotificationType notificationType) {
        return this.notifications.stream().filter(astNotificationEntry -> ((AstNotificationEntry)astNotificationEntry).notificationType == notificationType).findFirst().isPresent();
    }

    public boolean hasErrors() {
        return this.hasNotificationWithType(NotificationType.ERROR);
    }

    public boolean hasWarnings() {
        return this.hasNotificationWithType(NotificationType.WARNING);
    }

    private class AstNotificationEntry {
        private final NotificationType notificationType;
        private AstNodeLocation astNodeLocation;
        private I18nMessage i18nMessage;

        public AstNotificationEntry(NotificationType notificationType, AstNodeLocation astNodeLocation, I18nMessage i18nMessage) {
            this.notificationType = notificationType;
            this.astNodeLocation = astNodeLocation;
            this.i18nMessage = i18nMessage;
        }
    }

    private static enum NotificationType {
        ERROR,
        WARNING;

    }
}

