/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.util.AnnotationSupport;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;

abstract class BaseAstNode
implements AstNode {
    private final ComponentIdentifier componentIdentifier;
    private final AnnotationSupport<AstNodeAnnotation> annotationSupport;
    private String name;
    private AstNodeLocation astNodeLocation;

    public BaseAstNode(ComponentIdentifier componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
        this.annotationSupport = new AnnotationSupport();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public AstNodeLocation getAstNodeLocation() {
        return this.astNodeLocation;
    }

    public void setAstNodeLocation(AstNodeLocation astNodeLocation) {
        this.astNodeLocation = astNodeLocation;
    }

    @Override
    public ComponentIdentifier getIdentifier() {
        return this.componentIdentifier;
    }

    public Set<AstNodeAnnotation> getAnnotations() {
        return this.annotationSupport.getAnnotations();
    }

    public <T extends AstNodeAnnotation> Optional<T> getAnnotation(Class<T> annotation) {
        return this.annotationSupport.getAnnotation(annotation);
    }

    public <T extends AstNodeAnnotation> void annotate(T annotation) {
        this.annotationSupport.annotate(annotation);
    }

    public <T extends AstNodeAnnotation> boolean isAnnotatedWith(Class<T> annotationClass) {
        return this.annotationSupport.isAnnotatedWith(annotationClass);
    }

    public <T extends AstNodeAnnotation> T getOrCreateAnnotation(Class<T> annotationClass, Supplier<T> supplier) {
        return (T)((AstNodeAnnotation)this.annotationSupport.getOrCreateAnnotation(annotationClass, supplier));
    }

    public <T extends AstNodeAnnotation> Optional<T> deannotate(Class<T> annotation) {
        return this.annotationSupport.deannotate(annotation);
    }
}

