/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.BaseAstNode;
import org.mule.datasense.impl.model.types.MessageProcessorType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.metadata.api.model.FunctionType;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;

public class MessageProcessorNode
extends BaseAstNode {
    private FunctionType declaredFunctionType;
    private final ComponentIdentifier componentIdentifier;
    private final ComponentModel componentModel;
    private final List<MessageProcessorNode> messageProcessorNodeList;
    private AstNode parentAstNode;
    private boolean rootMessageProcessorNode;

    public MessageProcessorNode(ComponentIdentifier componentIdentifier, ComponentModel componentModel, List<MessageProcessorNode> messageProcessorNodeList, FunctionType declaredFunctionType) {
        super(componentIdentifier);
        Preconditions.checkNotNull((Object)componentIdentifier);
        Preconditions.checkNotNull(messageProcessorNodeList);
        this.setName(componentIdentifier.toString());
        this.componentIdentifier = componentIdentifier;
        this.componentModel = componentModel;
        this.messageProcessorNodeList = messageProcessorNodeList;
        this.declaredFunctionType = declaredFunctionType;
        if (this.declaredFunctionType == null) {
            this.declaredFunctionType = TypeUtils.asMetadataType(new MessageProcessorType());
        }
    }

    public MessageProcessorNode(ComponentIdentifier componentIdentifier, ComponentModel componentModel, List<MessageProcessorNode> messageProcessorNodeList) {
        this(componentIdentifier, componentModel, messageProcessorNodeList, null);
    }

    public void setParentAstNode(AstNode parentAstNode) {
        this.parentAstNode = parentAstNode;
    }

    public AstNode getParentAstNode() {
        return this.parentAstNode;
    }

    public boolean isRootMessageProcessorNode() {
        return this.rootMessageProcessorNode;
    }

    public void setRootMessageProcessorNode(boolean rootMessageProcessorNode) {
        this.rootMessageProcessorNode = rootMessageProcessorNode;
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public Stream<MessageProcessorNode> getMessageProcessorNodes() {
        return this.messageProcessorNodeList.stream();
    }

    @Override
    public <T> Object accept(AstNodeVisitor<T> astNodeVisitor, T context) {
        return astNodeVisitor.visit(this, context);
    }

    public FunctionType getDeclaredFunctionType() {
        return this.declaredFunctionType;
    }

    public ComponentModel getComponentModel() {
        return this.componentModel;
    }
}

