/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.operation;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.datasense.impl.model.operation.InputArgument;
import org.mule.datasense.impl.model.operation.InputMapping;
import org.mule.datasense.impl.model.operation.InputParameter;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.metadata.api.model.MetadataType;

public class OperationCallBuilder {
    private String name = "";
    private Map<String, InputMappingBuilder> inputMappingsMap = new HashMap<String, InputMappingBuilder>();
    private MetadataType returnType = null;

    public OperationCallBuilder name(String name) {
        this.name = name;
        return this;
    }

    public OperationCallBuilder input(Consumer<InputMappingBuilder> consumer) {
        InputMappingBuilder inputMappingBuilder = new InputMappingBuilder();
        consumer.accept(inputMappingBuilder);
        if (inputMappingBuilder.inputParameterBuilder != null) {
            String name = inputMappingBuilder.inputParameterBuilder.name;
            this.inputMappingsMap.put(name, inputMappingBuilder);
        }
        return this;
    }

    public OperationCallBuilder returnType(MetadataType returnType) {
        this.returnType = returnType;
        return this;
    }

    public OperationCall build() {
        return new OperationCall(this.name, this.inputMappingsMap.values().stream().map(InputMappingBuilder::build), this.returnType);
    }

    public static class InputArgumentBuilder {
        private String expression;

        public InputArgumentBuilder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public InputArgument build() {
            return new InputArgument(this.expression);
        }
    }

    public static class InputParameterBuilder {
        private String name;
        private MetadataType type;

        public InputParameterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InputParameterBuilder type(MetadataType type) {
            this.type = type;
            return this;
        }

        public InputParameter build() {
            return new InputParameter(this.name, this.type);
        }
    }

    public static class InputMappingBuilder {
        private InputParameterBuilder inputParameterBuilder = new InputParameterBuilder();
        private InputArgumentBuilder inputArgumentBuilder = new InputArgumentBuilder();

        public InputMappingBuilder parameter(Consumer<InputParameterBuilder> consumer) {
            this.inputParameterBuilder = new InputParameterBuilder();
            consumer.accept(this.inputParameterBuilder);
            return this;
        }

        public InputMappingBuilder argument(Consumer<InputArgumentBuilder> consumer) {
            this.inputArgumentBuilder = new InputArgumentBuilder();
            consumer.accept(this.inputArgumentBuilder);
            return this;
        }

        public InputMapping build() {
            return new InputMapping(this.inputParameterBuilder.build(), this.inputArgumentBuilder.build());
        }
    }
}

