/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import org.mule.datasense.impl.model.types.EventType;

public class MessageProcessorType {
    private final EventType inputEventType;
    private final EventType outputEventType;
    private final boolean propagates;

    public MessageProcessorType(EventType inputEventType, EventType outputEventType, boolean propagates) {
        this.inputEventType = inputEventType;
        this.outputEventType = outputEventType;
        this.propagates = propagates;
    }

    public MessageProcessorType() {
        this(new EventType(), new EventType(), true);
    }

    public EventType getInputEventType() {
        return this.inputEventType;
    }

    public EventType getOutputEventType() {
        return this.outputEventType;
    }

    public boolean isPropagates() {
        return this.propagates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageProcessorType that = (MessageProcessorType)o;
        if (this.propagates != that.propagates) {
            return false;
        }
        if (!this.inputEventType.equals(that.inputEventType)) {
            return false;
        }
        return this.outputEventType.equals(that.outputEventType);
    }

    public int hashCode() {
        int result = this.inputEventType.hashCode();
        result = 31 * result + this.outputEventType.hashCode();
        result = 31 * result + (this.propagates ? 1 : 0);
        return result;
    }

    public String toString() {
        return "MessageProcessorType{inputEventType=" + this.inputEventType + ", outputEventType=" + this.outputEventType + ", propagates=" + this.propagates + '}';
    }
}

