/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Map;
import java.util.Optional;
import org.mule.datasense.api.ComponentPath;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.model.annotations.ComponentPathAnnotation;
import org.mule.datasense.impl.model.annotations.HasDynamicMetadataAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.ComponentMetadataDescriptorAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.annotators.BaseOperationCallBuilderAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;

abstract class BaseDynamicAnnotator
extends BaseOperationCallBuilderAnnotator {
    BaseDynamicAnnotator() {
    }

    @Override
    public void annotate(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        Optional<DataSenseMetadataProvider> dataSenseMetadataProviderOptional;
        if (messageProcessorNode.isAnnotatedWith(HasDynamicMetadataAnnotation.class) && (dataSenseMetadataProviderOptional = annotatingMuleAstVisitorContext.getDataSenseProviderResolver().getDataSenseProvider().getDataSenseMetadataProvider()).isPresent()) {
            annotatingMuleAstVisitorContext.getAnnotation(MuleFlowAnnotation.class).ifPresent(muleFlowAnnotation -> messageProcessorNode.getAnnotation(ComponentPathAnnotation.class).ifPresent(componentPathAnnotation -> {
                MetadataResult<ComponentMetadataDescriptor> metadataResult = this.getComponentMetadataDescriptor((DataSenseMetadataProvider)dataSenseMetadataProviderOptional.get(), componentPathAnnotation.getComponentPath());
                messageProcessorNode.annotate(new ComponentMetadataDescriptorAnnotation(metadataResult));
                if (metadataResult.isSuccess()) {
                    MetadataResult outputMetadata;
                    ComponentMetadataDescriptor componentMetadataDescriptor = (ComponentMetadataDescriptor)metadataResult.get();
                    OperationCallBuilder operationCallBuilder = ((OperationCallBuilderAnnotation)messageProcessorNode.getOrCreateAnnotation(OperationCallBuilderAnnotation.class, OperationCallBuilderAnnotation::new)).getOperationCallBuilder();
                    String name = componentMetadataDescriptor.getName();
                    operationCallBuilder.name(name);
                    MetadataResult inputMetadata = componentMetadataDescriptor.getInputMetadata();
                    ComponentModel componentModel = messageProcessorNode.getComponentModel();
                    if (inputMetadata.isSuccess()) {
                        InputMetadataDescriptor inputMetadataDescriptor = (InputMetadataDescriptor)inputMetadata.get();
                        componentModel.getParameters().entrySet().stream().filter(stringStringEntry -> !"config-ref".equals(stringStringEntry.getKey())).forEach(entry -> {
                            MetadataResult parameterMetadata;
                            Map inputParameterMetadataDescriptors = inputMetadataDescriptor.getAllParameters();
                            if (inputParameterMetadataDescriptors.containsKey(entry.getKey()) && (parameterMetadata = (MetadataResult)inputParameterMetadataDescriptors.get(entry.getKey())).isSuccess()) {
                                operationCallBuilder.input(inputMappingBuilder -> {
                                    inputMappingBuilder.parameter(inputParameterBuilder -> {
                                        ParameterMetadataDescriptor parameterMetadataDescriptor = (ParameterMetadataDescriptor)parameterMetadata.get();
                                        inputParameterBuilder.name(parameterMetadataDescriptor.getName()).type(parameterMetadataDescriptor.getType());
                                    });
                                    inputMappingBuilder.argument(inputArgumentBuilder -> inputArgumentBuilder.expression((String)entry.getValue()));
                                });
                            }
                        });
                    }
                    if ((outputMetadata = componentMetadataDescriptor.getOutputMetadata()).isSuccess()) {
                        OutputMetadataDescriptor outputMetadataDescriptor = (OutputMetadataDescriptor)outputMetadata.get();
                        MetadataResult payloadMetadata = outputMetadataDescriptor.getPayloadMetadata();
                        MetadataResult attributesMetadata = outputMetadataDescriptor.getAttributesMetadata();
                        if (payloadMetadata.isSuccess() && attributesMetadata.isSuccess()) {
                            operationCallBuilder.returnType((MetadataType)TypesHelper.getMessageMetadataTypeBuilder().payload(((TypeMetadataDescriptor)payloadMetadata.get()).getType()).attributes(((TypeMetadataDescriptor)attributesMetadata.get()).getType()).build());
                        }
                    }
                }
            }));
        }
    }

    protected abstract MetadataResult<ComponentMetadataDescriptor> getComponentMetadataDescriptor(DataSenseMetadataProvider var1, ComponentPath var2);
}

