/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.HasDynamicMetadataAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.annotators.BaseOperationCallBuilderAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.datasense.impl.util.MutableHolder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;

abstract class BaseStaticAnnotator
extends BaseOperationCallBuilderAnnotator {
    BaseStaticAnnotator() {
    }

    @Override
    public void annotate(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        ComponentModel componentModel = messageProcessorNode.getComponentModel();
        annotatingMuleAstVisitorContext.getAnnotation(MuleFlowAnnotation.class).ifPresent(muleFlowAnnotation -> this.resolveComponentModel(messageProcessorNode, annotatingMuleAstVisitorContext.getDataSenseProviderResolver(), componentModel).ifPresent(metaComponentModel -> {
            MutableHolder<Boolean> hasDynamicTypeHolder = new MutableHolder<Boolean>(Boolean.FALSE);
            annotatingMuleAstVisitorContext.logger().debug("resolved operation model: " + metaComponentModel.getName());
            OperationCallBuilder operationCallBuilder = ((OperationCallBuilderAnnotation)messageProcessorNode.getOrCreateAnnotation(OperationCallBuilderAnnotation.class, OperationCallBuilderAnnotation::new)).getOperationCallBuilder();
            operationCallBuilder.name(metaComponentModel.getName());
            metaComponentModel.getAllParameterModels().forEach(parameterModel -> {
                String argument;
                Object defaultValue;
                hasDynamicTypeHolder.setValue((Boolean)hasDynamicTypeHolder.getValue() != false || parameterModel.hasDynamicType());
                boolean required = parameterModel.isRequired();
                String argumentCandidate = (String)componentModel.getParameters().get(parameterModel.getName());
                if (argumentCandidate == null && (defaultValue = parameterModel.getDefaultValue()) instanceof String) {
                    argumentCandidate = ExpressionLanguageUtils.extractExpression((String)defaultValue).map(s -> s).orElse(null);
                }
                if ((argument = argumentCandidate) != null) {
                    ExpressionSupport expressionSupport = parameterModel.getExpressionSupport();
                    operationCallBuilder.input(inputMappingBuilder -> inputMappingBuilder.parameter(inputParameterBuilder -> inputParameterBuilder.name(parameterModel.getName()).type(parameterModel.getType())).argument(inputArgumentBuilder -> inputArgumentBuilder.expression(argument)));
                } else if (required) {
                    this.reportError(I18nMessageFactory.createStaticMessage((String)"required parameter missing"), messageProcessorNode, annotatingMuleAstVisitorContext);
                }
            });
            boolean hasDynamicType = hasDynamicTypeHolder.getValue();
            operationCallBuilder.returnType((MetadataType)TypesHelper.getMessageMetadataTypeBuilder().payload(metaComponentModel.getOutput().getType()).attributes(metaComponentModel.getOutputAttributes().getType()).build());
            hasDynamicType = hasDynamicType || metaComponentModel.getOutput().hasDynamicType() || metaComponentModel.getOutputAttributes().hasDynamicType();
            annotatingMuleAstVisitorContext.logger().debug(String.format("component model: %s, hasDynamicType: %s", metaComponentModel.getName(), hasDynamicType));
            if (hasDynamicType) {
                messageProcessorNode.annotate(new HasDynamicMetadataAnnotation());
            }
        }));
    }

    protected abstract Optional<org.mule.runtime.api.meta.model.ComponentModel> resolveComponentModel(MessageProcessorNode var1, DataSenseProviderResolver var2, ComponentModel var3);
}

