/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.List;
import java.util.Optional;
import org.mule.datasense.api.ComponentPath;
import org.mule.datasense.impl.model.annotations.ComponentPathAnnotation;
import org.mule.datasense.impl.model.annotations.HasSourceAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.annotators.BaseAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;

public class InfoAnnotator
extends BaseAnnotator {
    @Override
    public void annotate(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        this.annotateComponentPath(messageProcessorNode, annotatingMuleAstVisitorContext);
    }

    private int indexOf(List<ComponentModel> innerComponentModels, ComponentModel componentModel) {
        int index = -1;
        for (ComponentModel childComponentModel : innerComponentModels) {
            ++index;
            if (componentModel != childComponentModel) continue;
            return index;
        }
        throw new IllegalArgumentException();
    }

    private void annotateComponentPath(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        annotatingMuleAstVisitorContext.getAnnotation(MuleApplicationAnnotation.class).ifPresent(muleApplicationAnnotation -> {
            MuleApplicationNode muleApplicationNode = muleApplicationAnnotation.getMuleApplicationNode();
            annotatingMuleAstVisitorContext.getAnnotation(MuleFlowAnnotation.class).ifPresent(muleFlowAnnotation -> {
                Optional<ComponentPath> componentPathOptional;
                MuleFlowNode muleFlowNode = muleFlowAnnotation.getMuleFlowNode();
                if (messageProcessorNode.isRootMessageProcessorNode()) {
                    componentPathOptional = Optional.of(new ComponentPath(muleFlowNode.getName()));
                } else {
                    MessageProcessorNode parentMessageProcessorNode = (MessageProcessorNode)messageProcessorNode.getParentAstNode();
                    componentPathOptional = parentMessageProcessorNode.getAnnotation(ComponentPathAnnotation.class).map(componentPathAnnotation -> {
                        boolean hasSource = muleFlowNode.isAnnotatedWith(HasSourceAnnotation.class);
                        ComponentModel componentModel = messageProcessorNode.getComponentModel();
                        boolean sourceLevel = ((MessageProcessorNode)messageProcessorNode.getParentAstNode()).isRootMessageProcessorNode();
                        List innerComponents = componentModel.getParent().getInnerComponents();
                        int index = this.indexOf(innerComponents, componentModel);
                        if (sourceLevel) {
                            --index;
                        }
                        ComponentPath componentPath = componentPathAnnotation.getComponentPath();
                        return ComponentPath.valueOf(componentPath, index == -1 ? "source" : String.valueOf(index));
                    });
                }
                componentPathOptional.ifPresent(componentPath -> {
                    messageProcessorNode.annotate(new ComponentPathAnnotation((ComponentPath)componentPath));
                    muleFlowNode.register((ComponentPath)componentPath, messageProcessorNode);
                    muleApplicationNode.register((ComponentPath)componentPath, messageProcessorNode);
                });
            });
        });
    }
}

