/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.annotations.MessageSourceRegionContextAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.annotators.BaseAnnotator;
import org.mule.datasense.impl.phases.annotators.OperationAnnotator;
import org.mule.datasense.impl.phases.annotators.SourceAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;

public class OperationCallAnnotator
extends BaseAnnotator {
    private final SourceAnnotator sourceAnnotator = new SourceAnnotator();
    private final OperationAnnotator operationAnnotator = new OperationAnnotator();

    @Override
    public void annotate(MessageProcessorNode messageProcessorNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        if (!messageProcessorNode.isRootMessageProcessorNode()) {
            if (annotatingMuleAstVisitorContext.isAnnotatedWith(MessageSourceRegionContextAnnotation.class)) {
                this.sourceAnnotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext);
                if (!messageProcessorNode.isAnnotatedWith(OperationCallBuilderAnnotation.class)) {
                    this.operationAnnotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext);
                }
            } else {
                this.operationAnnotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext);
            }
            messageProcessorNode.getAnnotation(OperationCallBuilderAnnotation.class).ifPresent(operationCallBuilderAnnotation -> {
                OperationCallBuilder operationCallBuilder = operationCallBuilderAnnotation.getOperationCallBuilder();
                OperationCall operationCall = operationCallBuilder.build();
                messageProcessorNode.annotate(new OperationCallAnnotation(operationCall));
                messageProcessorNode.annotate(new TypeResolverAnnotation("operation-call"));
            });
        }
    }
}

