/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleFlowNodeBuilder;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;

public class MuleApplicationNodeBuilder
implements AstNodeBuilder<MuleApplicationNode> {
    private final ComponentIdentifier componentIdentifier;
    private List<MuleFlowNodeBuilder> muleFlowNodeList;
    private String name;

    public MuleApplicationNodeBuilder(ComponentIdentifier componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
        this.muleFlowNodeList = new ArrayList<MuleFlowNodeBuilder>();
    }

    public MuleApplicationNodeBuilder name(String name) {
        this.name = name;
        return this;
    }

    public MuleApplicationNodeBuilder muleFlow(ComponentIdentifier componentIdentifier, Consumer<MuleFlowNodeBuilder> muleFlowNodeBuilderConsumer) {
        MuleFlowNodeBuilder muleFlowNodeBuilder = new MuleFlowNodeBuilder(componentIdentifier);
        if (muleFlowNodeBuilderConsumer != null) {
            muleFlowNodeBuilderConsumer.accept(muleFlowNodeBuilder);
        }
        return this.muleFlow(muleFlowNodeBuilder);
    }

    public MuleApplicationNodeBuilder muleFlow(MuleFlowNodeBuilder muleFlowNodeBuilder) {
        this.muleFlowNodeList.add(muleFlowNodeBuilder);
        return this;
    }

    @Override
    public MuleApplicationNode build() {
        List<MuleFlowNode> muleFlowNodes = this.muleFlowNodeList.stream().map(MuleFlowNodeBuilder::build).collect(Collectors.toList());
        MuleApplicationNode muleApplicationNode = new MuleApplicationNode(this.componentIdentifier, muleFlowNodes.stream());
        muleApplicationNode.setName(this.name);
        muleFlowNodes.forEach(muleFlowNode -> muleFlowNode.setParentAstNode(muleApplicationNode));
        return muleApplicationNode;
    }
}

