/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.annotators.AnnotatorsRegistry;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitor;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitorContext;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;

public class AstTyping {
    private final TypeResolverRegistry typeResolverRegistry;
    private final AnnotatorsRegistry annotatorsRegistry;

    public AstTyping(AnnotatorsRegistry annotatorsRegistry, TypeResolverRegistry typeResolverRegistry) {
        this.annotatorsRegistry = annotatorsRegistry;
        this.typeResolverRegistry = typeResolverRegistry;
    }

    public void annotate(AstNode astNode, DataSenseProviderResolver dataSenseProviderResolver, AstNotification astNotification) {
        AnnotatingMuleAstVisitor annotatingMuleAstVisitor = new AnnotatingMuleAstVisitor(this.annotatorsRegistry);
        annotatingMuleAstVisitor.annotate(astNode, dataSenseProviderResolver, astNotification);
    }

    public void resolveTypes(AstNode astNode, EventType eventType, AstNotification astNotification) {
        TypingMuleAstVisitor typingMuleAstVisitor = new TypingMuleAstVisitor(this.typeResolverRegistry);
        typingMuleAstVisitor.resolveType(astNode, eventType, astNotification);
    }

    public void generateIncoming(AstNode astNode, EventType eventType, AstNotification astNotification) {
        IncomingAstVisitorContext incomingAstVisitorContext = new IncomingAstVisitorContext(astNotification);
        astNode.accept(new IncomingAstVisitor(), incomingAstVisitorContext);
    }

    public void generateExpected(AstNode astNode, EventType eventType, AstNotification astNotification) {
        ExpectedAstVisitorContext expectedAstVisitorContext = new ExpectedAstVisitorContext(astNotification);
        astNode.accept(new ExpectedAstVisitor(), expectedAstVisitorContext);
    }
}

