/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.MessageProcessorScope;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;

public class TypingMuleAstVisitor
implements AstNodeVisitor<TypingMuleAstVisitorContext> {
    private final TypeResolverRegistry typeResolverRegistry;

    public TypingMuleAstVisitor(TypeResolverRegistry typeResolverRegistry) {
        Preconditions.checkNotNull((Object)typeResolverRegistry);
        this.typeResolverRegistry = typeResolverRegistry;
    }

    @Override
    public Object visit(MuleApplicationNode muleApplicationNode, TypingMuleAstVisitorContext visitorContext) {
        visitorContext.logger().enter(muleApplicationNode.getName());
        muleApplicationNode.getMuleFlowNodes().forEach(muleFlowNode -> muleFlowNode.accept(this, visitorContext));
        visitorContext.logger().exit(muleApplicationNode.getName());
        return null;
    }

    @Override
    public Object visit(MuleFlowNode muleFlowNode, TypingMuleAstVisitorContext visitorContext) {
        visitorContext.logger().enter(muleFlowNode.getName());
        EventType result = (EventType)muleFlowNode.getRootMessageProcessorNode().accept(this, visitorContext);
        visitorContext.logger().exit(muleFlowNode.getName());
        return result;
    }

    @Override
    public Object visit(MessageProcessorNode messageProcessorNode, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        typingMuleAstVisitorContext.logger().enter(messageProcessorNode.getComponentIdentifier().toString());
        EventType result = typingMuleAstVisitorContext.getTypeResolverRegistry().get(messageProcessorNode.getAnnotation(TypeResolverAnnotation.class).map(typeResolverAnnotation -> ComponentIdentifier.parseComponentIdentifier((String)typeResolverAnnotation.getTypeResolver())).orElse(messageProcessorNode.getComponentIdentifier())).map(muleAstFunctionTypeResolver -> muleAstFunctionTypeResolver.resolveTypes(messageProcessorNode, this, typingMuleAstVisitorContext)).orElse(new EventType());
        typingMuleAstVisitorContext.logger().exit(messageProcessorNode.getComponentIdentifier().toString());
        return result;
    }

    public EventType resolveType(AstNode astNode, EventType inputEventType, AstNotification astNotification) {
        return this.resolveType(astNode, inputEventType, new TypingMuleAstVisitorContext(this.typeResolverRegistry, astNotification));
    }

    public EventType resolveType(AstNode astNode, EventType inputEvent, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        typingMuleAstVisitorContext.getTypingEnvironment().push(new MessageProcessorScope(inputEvent));
        EventType result = (EventType)astNode.accept(this, typingMuleAstVisitorContext);
        typingMuleAstVisitorContext.getTypingEnvironment().pop();
        return result;
    }
}

