/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.ResolvedTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.MessageProcessorType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;

public abstract class BaseTypeResolver
implements TypeResolver {
    @Override
    public EventType resolveTypes(MessageProcessorNode messageProcessorNode, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        EventType argumentEventType = typingMuleAstVisitorContext.getTypingEnvironment().get().resolveInput();
        EventType resultEventType = this.resolve(messageProcessorNode, argumentEventType, typingMuleAstVisitor, typingMuleAstVisitorContext);
        EventType usesEventType = messageProcessorNode.getAnnotation(UsesTypeAnnotation.class).map(UsesTypeAnnotation::getUsesEventType).orElse(new EventType());
        EventType definesEventType = messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).map(DefinesTypeAnnotation::getDefinesEventType).orElse(new EventType());
        messageProcessorNode.annotate(new ResolvedTypeAnnotation(new MessageProcessorType(usesEventType, definesEventType, this.isPropagates())));
        return resultEventType;
    }

    protected EventType unifyEventTypes(EventType sourceEventType, EventType targetEventType, boolean source) {
        return source ? sourceEventType : targetEventType;
    }

    protected MessageProcessorType getResolvedType(MessageProcessorNode messageProcessorNode) {
        return messageProcessorNode.getAnnotation(ResolvedTypeAnnotation.class).map(ResolvedTypeAnnotation::getMessageProcessorType).orElse(new MessageProcessorType());
    }

    protected abstract EventType resolve(MessageProcessorNode var1, EventType var2, TypingMuleAstVisitor var3, TypingMuleAstVisitorContext var4);

    protected abstract boolean isPropagates();
}

