/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.InputArgument;
import org.mule.datasense.impl.model.operation.InputParameter;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class OperationCallTypeResolver
extends SingleNodeTypeResolver {
    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        Optional annotation = messageProcessorNode.getAnnotation(OperationCallAnnotation.class);
        if (annotation.isPresent()) {
            OperationCallAnnotation operationCallAnnotation = (OperationCallAnnotation)annotation.get();
            OperationCall operationCall = operationCallAnnotation.getOperationCall();
            MuleEventMetadataTypeBuilder inferredMuleEventTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
            operationCall.getInputMappings().forEach(inputMapping -> {
                InputArgument inputArgument = inputMapping.getInputArgument();
                InputParameter inputParameter = inputMapping.getInputParameter();
                Optional<String> optionalExpression = ExpressionLanguageUtils.extractExpression(inputArgument.getExpression());
                if (optionalExpression.isPresent()) {
                    String expression = optionalExpression.get();
                    Optional<MetadataType> inputArgumentTypeOptional = Optional.ofNullable(ExpressionLanguageUtils.resolveExpressionType(expression, inputEventType, visitorContext.getExpressionLanguageMetadataTypeResolver()));
                    if ("payload".equals(expression)) {
                        inferredMuleEventTypeBuilder.message().payload(inputParameter.getMetadataType());
                    } else if ("attributes".equals(expression)) {
                        inferredMuleEventTypeBuilder.message().attributes(inputParameter.getMetadataType());
                    } else {
                        MuleEventMetadataType expectedEventType = ExpressionLanguageUtils.getExpectedEventType(expression, visitorContext.getExpressionLanguageMetadataTypeResolver());
                        EventType eventType = TypeUtils.asEventType(expectedEventType);
                        List varDecls = eventType.getVarDecls().collect(Collectors.toList());
                        if (varDecls.size() == 1) {
                            inferredMuleEventTypeBuilder.addVariable(((VarDecl)varDecls.get(0)).getName(), inputParameter.getMetadataType());
                        }
                    }
                    inputArgumentTypeOptional.ifPresent(metadataType -> {
                        if (!TypeUtils.isAssignable(metadataType, inputParameter.getMetadataType())) {
                            visitorContext.getAstNotification().reportError(null, I18nMessageFactory.createStaticMessage((String)"unassignable"));
                        }
                    });
                }
            });
            MuleEventMetadataType inferredInputMuleEventType = inferredMuleEventTypeBuilder.build();
            messageProcessorNode.annotate(new UsesTypeAnnotation(TypeUtils.asEventType(inferredInputMuleEventType)));
            MetadataType returnType = operationCall.getReturnType();
            EventType outputEventType = new EventType(Stream.of(new VarDecl("#message#", returnType)));
            messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
            return outputEventType;
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean isPropagates() {
        return false;
    }
}

