/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.el.ExpressionLanguageMetadataTypeResolver;

public class SetVariableTypeResolver
extends SingleNodeTypeResolver {
    private static final String FIELD_VALUE = "value";
    private static final String FIELD_VARIABLE = "variable";

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver = visitorContext.getExpressionLanguageMetadataTypeResolver();
        EventType definesEventType = new EventType(Stream.of(new VarDecl(this.getVarDeclName(messageProcessorNode), this.generateMetadaType(this.resolveValueType(messageProcessorNode, inputEventType, expressionLanguageMetadataTypeResolver)))));
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(definesEventType));
        return TypeUtils.merge(inputEventType, definesEventType);
    }

    protected String getVarDeclName(MessageProcessorNode messageProcessorNode) {
        return (String)messageProcessorNode.getComponentModel().getParameters().get(FIELD_VARIABLE);
    }

    protected MetadataType generateMetadaType(Optional<MetadataType> expressionType) {
        return expressionType.orElse((MetadataType)TypesHelper.getTypeBuilder().voidType().build());
    }

    private Optional<MetadataType> resolveValueType(MessageProcessorNode messageProcessorNode, EventType inputEventType, ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver) {
        Optional<Object> result = Optional.empty();
        String value = (String)messageProcessorNode.getComponentModel().getParameters().get(FIELD_VALUE);
        if (value != null) {
            Optional<String> expression = ExpressionLanguageUtils.extractExpression(value);
            result = expression.isPresent() ? Optional.ofNullable(ExpressionLanguageUtils.resolveExpressionType(expression.get(), inputEventType, expressionLanguageMetadataTypeResolver)) : Optional.of(TypesHelper.getTypeBuilder().stringType().build());
        }
        return result;
    }

    @Override
    protected boolean isPropagates() {
        return false;
    }
}

