/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.annotations;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.LogSupport;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.config.spring.dsl.model.DslElementModel;

public class ComponentModelMetadataKeyEnricher
implements LogSupport {
    protected String[] enumOfKeyValues(Set<MetadataKey> metadataKeys) {
        List<String> collect = metadataKeys.stream().map(MetadataKey::getId).collect(Collectors.toList());
        return collect.toArray(new String[collect.size()]);
    }

    protected <T extends ComponentModel> Optional<String> findKeyPartConfiguredValue(DslElementModel<T> componentModelDslElementModel, String keyPartName) {
        return componentModelDslElementModel.getConfiguration().map(componentConfiguration -> (String)componentConfiguration.getParameters().get(keyPartName));
    }

    protected <T extends ComponentModel> Optional<Set<MetadataKey>> filterMetadataKeys(Set<MetadataKey> metadataKeys, DslElementModel<T> componentModelDslElementModel) {
        Optional<String> optionalKeyPart = metadataKeys.stream().findFirst().map(MetadataKey::getPartName);
        if (!optionalKeyPart.isPresent()) {
            return Optional.empty();
        }
        String keyPart = optionalKeyPart.get();
        Optional<String> optionalKeyPartConfiguredValue = this.findKeyPartConfiguredValue(componentModelDslElementModel, keyPart);
        if (!optionalKeyPartConfiguredValue.isPresent()) {
            return Optional.of(metadataKeys);
        }
        String KeyPartConfiguredValue = optionalKeyPartConfiguredValue.get();
        Optional<MetadataKey> matchingKey = metadataKeys.stream().filter(metadataKey1 -> metadataKey1.getId().equals(KeyPartConfiguredValue)).findFirst();
        if (matchingKey.isPresent()) {
            return this.filterMetadataKeys(matchingKey.get().getChilds(), componentModelDslElementModel);
        }
        return Optional.of(metadataKeys);
    }

    protected Function<ParameterModel, MetadataType> getParameterModelMetadataTypeFunction(Set<MetadataKey> metadataKeys, String partName) {
        return parameterModel -> {
            if (parameterModel.getName().equals(partName) && parameterModel.getType() instanceof StringType) {
                return TypesHelper.getTypeBuilder(MetadataFormat.JAVA).stringType().enumOf(this.enumOfKeyValues(metadataKeys)).build();
            }
            return parameterModel.getType();
        };
    }
}

