/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.annotations;

import java.util.Optional;
import java.util.Set;
import org.mule.datasense.api.ComponentPath;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.model.annotations.ComponentModelMetadataKeyEnricher;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.util.extension.OutputModelTransform;
import org.mule.datasense.impl.util.extension.ParameterGroupModelTransform;
import org.mule.datasense.impl.util.extension.SourceCallbackModelTransform;
import org.mule.datasense.impl.util.extension.SourceModelTransform;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.spring.dsl.model.DslElementModel;

public class SourceModelMetadataKeyEnricher
extends ComponentModelMetadataKeyEnricher {
    public SourceModel enrich(DslElementModel<SourceModel> componentModelDslElementModel, ComponentPath componentPath, DataSenseMetadataProvider dataSenseMetadataProvider, AstNotification astNotification) {
        SourceModel result = (SourceModel)componentModelDslElementModel.getModel();
        MetadataResult<MetadataKeysContainer> metadataResult = dataSenseMetadataProvider.getMetadataKeys(componentPath);
        if (metadataResult != null) {
            if (metadataResult.isSuccess()) {
                MetadataKeysContainer metadataKeysContainer = (MetadataKeysContainer)metadataResult.get();
                Optional optionalFilteredMetadataKeys = metadataKeysContainer.getKeysByCategory().values().stream().findFirst().flatMap(metadataKeys -> this.filterMetadataKeys((Set<MetadataKey>)metadataKeys, componentModelDslElementModel));
                if (optionalFilteredMetadataKeys.isPresent()) {
                    result = this.enrich((SourceModel)componentModelDslElementModel.getModel(), (Set)optionalFilteredMetadataKeys.get());
                }
            } else {
                metadataResult.getFailures().forEach(metadataFailure -> astNotification.reportError(null, I18nMessageFactory.createStaticMessage((String)"Failed to enrich keys. [%s/%s] CODE:%s - %s, Reason: %s.", (Object[])new Object[]{metadataFailure.getFailingComponent(), metadataFailure.getFailingElement().orElse(""), metadataFailure.getFailureCode(), metadataFailure.getMessage(), metadataFailure.getReason()})));
                result = (SourceModel)componentModelDslElementModel.getModel();
            }
        } else {
            astNotification.reportError(null, I18nMessageFactory.createStaticMessage((String)"Failed to to obtain dynamic metadata resolving request [%s].", (Object[])new Object[]{"metadatakeys for component_path: " + componentPath}));
        }
        return result;
    }

    private SourceModel enrich(SourceModel componentModel, Set<MetadataKey> metadataKeys) {
        return metadataKeys.stream().findFirst().map(metadataKey -> {
            String partName = metadataKey.getPartName();
            SourceModelTransform sourceModelTransform = new SourceModelTransform(new ParameterGroupModelTransform(this.getParameterModelMetadataTypeFunction(metadataKeys, partName)), new OutputModelTransform(), new OutputModelTransform(), new SourceCallbackModelTransform(), new SourceCallbackModelTransform());
            return sourceModelTransform.transform(componentModel);
        }).orElse(componentModel);
    }
}

