/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.runtime.api.i18n.I18nMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstNotification {
    public static final transient Logger logger = LoggerFactory.getLogger((String)"org.mule.datasense.notifications");
    private List<AstNotificationEntry> notifications = new LinkedList<AstNotificationEntry>();

    public List<String> getPlainMessages() {
        return this.notifications.stream().map(this::plainMessage).collect(Collectors.toList());
    }

    private String plainMessage(AstNotificationEntry astNotificationEntry) {
        return String.format("[%s] %s", new Object[]{astNotificationEntry.getNotificationType(), astNotificationEntry.getI18nMessage().getMessage()});
    }

    private void log(AstNotificationEntry astNotificationEntry) {
        if (logger.isDebugEnabled()) {
            logger.error("[{}] {}", (Object)astNotificationEntry.getNotificationType(), (Object)astNotificationEntry.getI18nMessage().getMessage());
        }
    }

    private void report(AstNotificationEntry astNotificationEntry) {
        this.log(astNotificationEntry);
        this.notifications.add(astNotificationEntry);
    }

    public void reportFatalError(AstNodeLocation astNodeLocation, I18nMessage i18nMessage) {
        this.report(new AstNotificationEntry(NotificationType.FATAL_ERROR, astNodeLocation, i18nMessage));
    }

    public void reportError(AstNodeLocation astNodeLocation, I18nMessage i18nMessage) {
        this.report(new AstNotificationEntry(NotificationType.ERROR, astNodeLocation, i18nMessage));
    }

    public void reportWarning(AstNodeLocation astNodeLocation, I18nMessage i18nMessage) {
        this.report(new AstNotificationEntry(NotificationType.WARNING, astNodeLocation, i18nMessage));
    }

    public void reportInfo(AstNodeLocation astNodeLocation, I18nMessage i18nMessage) {
        this.report(new AstNotificationEntry(NotificationType.INFO, astNodeLocation, i18nMessage));
    }

    private boolean hasNotificationWithType(NotificationType notificationType) {
        return this.notifications.stream().filter(astNotificationEntry -> ((AstNotificationEntry)astNotificationEntry).notificationType == notificationType).findFirst().isPresent();
    }

    public boolean hasErrors() {
        return this.hasNotificationWithType(NotificationType.ERROR);
    }

    public boolean hasWarnings() {
        return this.hasNotificationWithType(NotificationType.WARNING);
    }

    public boolean hasFatalErrors() {
        return this.hasNotificationWithType(NotificationType.FATAL_ERROR);
    }

    private class AstNotificationEntry {
        private final NotificationType notificationType;
        private AstNodeLocation astNodeLocation;
        private I18nMessage i18nMessage;

        public AstNotificationEntry(NotificationType notificationType, AstNodeLocation astNodeLocation, I18nMessage i18nMessage) {
            this.notificationType = notificationType;
            this.astNodeLocation = astNodeLocation;
            this.i18nMessage = i18nMessage;
        }

        public NotificationType getNotificationType() {
            return this.notificationType;
        }

        public AstNodeLocation getAstNodeLocation() {
            return this.astNodeLocation;
        }

        public I18nMessage getI18nMessage() {
            return this.i18nMessage;
        }
    }

    private static enum NotificationType {
        FATAL_ERROR,
        ERROR,
        WARNING,
        INFO;

    }
}

