/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.VisitorContextAnnotation;
import org.mule.datasense.impl.util.AnnotationSupport;
import org.mule.datasense.impl.util.TreeLogSupport;

public abstract class BaseAstNodeVisitorContext {
    private AnnotationSupport<VisitorContextAnnotation> annotationSupport;
    private final TreeLogSupport treeLogSupport;
    private final AstNotification astNotification;

    public BaseAstNodeVisitorContext(AstNotification astNotification) {
        this.astNotification = astNotification;
        this.treeLogSupport = new TreeLogSupport();
        this.annotationSupport = new AnnotationSupport();
    }

    public AstNotification getAstNotification() {
        return this.astNotification;
    }

    public TreeLogSupport logger() {
        return this.treeLogSupport;
    }

    public Set<VisitorContextAnnotation> getAnnotations() {
        return this.annotationSupport.getAnnotations();
    }

    public <T extends VisitorContextAnnotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        return this.annotationSupport.getAnnotation(annotationClass);
    }

    public <T extends VisitorContextAnnotation> void annotate(T annotation) {
        this.annotationSupport.annotate(annotation);
    }

    public <T extends VisitorContextAnnotation> Optional<T> deannotate(Class<T> annotation) {
        return this.annotationSupport.deannotate(annotation);
    }

    public <T extends VisitorContextAnnotation> boolean isAnnotatedWith(Class<T> annotationClass) {
        return this.annotationSupport.isAnnotatedWith(annotationClass);
    }

    public <T extends VisitorContextAnnotation> T getOrCreateAnnotation(Class<T> annotationClass, Supplier<T> supplier) {
        return (T)((VisitorContextAnnotation)this.annotationSupport.getOrCreateAnnotation(annotationClass, supplier));
    }
}

