/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.datasense.api.ComponentPath;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.BaseAstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;

public class MuleApplicationNode
extends BaseAstNode {
    private final List<MuleFlowNode> muleFlowNodes = new ArrayList<MuleFlowNode>();
    private final Map<String, MuleFlowNode> muleFlowNodeByNameMap = new HashMap<String, MuleFlowNode>();
    private Map<ComponentPath, MessageProcessorNode> messageProcessorNodeMap = new HashMap<ComponentPath, MessageProcessorNode>();

    public MuleApplicationNode(ComponentIdentifier componentIdentifier, Stream<MuleFlowNode> muleFlowNodes) {
        super(componentIdentifier);
        muleFlowNodes.forEach(this::add);
    }

    private void add(MuleFlowNode muleFlowNode) {
        this.muleFlowNodes.add(muleFlowNode);
        this.muleFlowNodeByNameMap.put(muleFlowNode.getName(), muleFlowNode);
    }

    public Stream<MuleFlowNode> getMuleFlowNodes() {
        return this.muleFlowNodes.stream();
    }

    @Override
    public <T> Object accept(AstNodeVisitor<T> astNodeVisitor, T context) {
        return astNodeVisitor.visit(this, context);
    }

    public void register(ComponentPath componentPath, MessageProcessorNode messageProcessorNode) {
        Preconditions.checkState((!this.messageProcessorNodeMap.containsKey(componentPath) ? 1 : 0) != 0, (Object)String.format("Node already registered for componentPath %s", componentPath));
        this.messageProcessorNodeMap.put(componentPath, messageProcessorNode);
    }

    public Optional<MessageProcessorNode> findMessageProcessorNode(ComponentPath componentPath) {
        return Optional.ofNullable(this.messageProcessorNodeMap.get(componentPath));
    }
}

