/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.operation;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.operation.InputMapping;
import org.mule.metadata.api.model.MetadataType;

public class OperationCall {
    private String name;
    private final List<InputMapping> inputMappingList;
    private final MetadataType returnType;
    private final String target;

    public OperationCall(String name, Stream<InputMapping> inputMappings, MetadataType returnType, String target) {
        this.name = name;
        this.inputMappingList = inputMappings.collect(Collectors.toList());
        this.returnType = returnType;
        this.target = target;
    }

    public String getName() {
        return this.name;
    }

    public Stream<InputMapping> getInputMappings() {
        return this.inputMappingList.stream();
    }

    public MetadataType getReturnType() {
        return this.returnType;
    }

    public Optional<String> getTarget() {
        return Optional.ofNullable(this.target);
    }
}

