/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.scoping;

import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.datasense.impl.model.annotations.ExpectedEventAnnotation;
import org.mule.datasense.impl.model.annotations.ResolvedTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.MessageProcessorType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;

public class ExpectedAstVisitor
implements AstNodeVisitor<ExpectedAstVisitorContext> {
    @Override
    public Object visit(MessageProcessorNode messageProcessorNode, ExpectedAstVisitorContext visitorContext) {
        visitorContext.logger().enter(messageProcessorNode.getName());
        EventType expectedEventType = visitorContext.getExpectedEventType();
        ExpectedEventAnnotation expectedEventAnnotation = new ExpectedEventAnnotation(expectedEventType);
        messageProcessorNode.annotate(expectedEventAnnotation);
        visitorContext.logger().debug(String.format("received event: %s in mp: %s", visitorContext.getExpectedEventType(), messageProcessorNode.getName()), new Object[0]);
        EventType[] propagatedEvent = new EventType[]{expectedEventType};
        messageProcessorNode.getMessageProcessorNodes().collect(Collectors.toCollection(LinkedList::new)).descendingIterator().forEachRemaining(innerMessageProcessorNode -> {
            visitorContext.setExpectedEventType(propagatedEvent[0]);
            propagatedEvent[0] = (EventType)innerMessageProcessorNode.accept(this, visitorContext);
        });
        Optional<MessageProcessorType> optionalMessageProcessorType = messageProcessorNode.getAnnotation(ResolvedTypeAnnotation.class).map(ResolvedTypeAnnotation::getMessageProcessorType);
        EventType declaredInputEventType = optionalMessageProcessorType.map(MessageProcessorType::getInputEventType).orElse(new EventType());
        EventType declaredOutputEventType = optionalMessageProcessorType.map(MessageProcessorType::getOutputEventType).orElse(new EventType());
        boolean copyProperties = optionalMessageProcessorType.map(MessageProcessorType::isPropagates).orElse(true);
        EventType eventType = new EventType(propagatedEvent[0].getVarDecls().filter(varDecl -> !declaredOutputEventType.get(varDecl.getName()).isPresent()));
        EventType inputEventType = copyProperties ? TypeUtils.merge(eventType, declaredInputEventType) : declaredInputEventType;
        visitorContext.logger().exit(messageProcessorNode.getName());
        return inputEventType;
    }

    @Override
    public Object visit(MuleApplicationNode muleApplicationNode, ExpectedAstVisitorContext visitorContext) {
        visitorContext.logger().enter(muleApplicationNode.getName());
        muleApplicationNode.getMuleFlowNodes().forEach(muleFlowNode -> muleFlowNode.accept(this, visitorContext));
        visitorContext.logger().exit(muleApplicationNode.getName());
        return null;
    }

    @Override
    public Object visit(MuleFlowNode muleFlowNode, ExpectedAstVisitorContext visitorContext) {
        visitorContext.logger().enter(muleFlowNode.getName());
        visitorContext.setExpectedEventType(new EventType());
        muleFlowNode.getRootMessageProcessorNode().accept(this, visitorContext);
        visitorContext.logger().exit(muleFlowNode.getName());
        return null;
    }
}

