/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.scoping;

import java.util.Optional;
import org.mule.datasense.impl.model.annotations.IncomingEventAnnotation;
import org.mule.datasense.impl.model.annotations.ResolvedTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.MessageProcessorType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitorContext;

public class IncomingAstVisitor
implements AstNodeVisitor<IncomingAstVisitorContext> {
    @Override
    public Object visit(MessageProcessorNode messageProcessorNode, IncomingAstVisitorContext visitorContext) {
        visitorContext.logger().enter(messageProcessorNode.getName());
        EventType incomingEventType = visitorContext.getIncomingEventType();
        IncomingEventAnnotation incomingEventAnnotation = new IncomingEventAnnotation(incomingEventType);
        messageProcessorNode.annotate(incomingEventAnnotation);
        visitorContext.logger().debug(String.format("received event: %s in mp: %s", visitorContext.getIncomingEventType(), messageProcessorNode.getName()), new Object[0]);
        EventType[] propagatedEvent = new EventType[]{incomingEventType};
        messageProcessorNode.getMessageProcessorNodes().forEach(innerMessageProcessorNode -> {
            visitorContext.setIncomingEventType(propagatedEvent[0]);
            propagatedEvent[0] = (EventType)innerMessageProcessorNode.accept(this, visitorContext);
        });
        Optional<MessageProcessorType> optionalMessageProcessorType = messageProcessorNode.getAnnotation(ResolvedTypeAnnotation.class).map(ResolvedTypeAnnotation::getMessageProcessorType);
        EventType declaredOutputEventType = optionalMessageProcessorType.map(MessageProcessorType::getOutputEventType).orElse(new EventType());
        boolean copyProperties = optionalMessageProcessorType.map(MessageProcessorType::isPropagates).orElse(true);
        EventType outputEventType = copyProperties ? TypeUtils.merge(propagatedEvent[0], declaredOutputEventType) : declaredOutputEventType;
        visitorContext.logger().exit(messageProcessorNode.getName());
        return outputEventType;
    }

    @Override
    public Object visit(MuleApplicationNode muleApplicationNode, IncomingAstVisitorContext visitorContext) {
        visitorContext.logger().enter(muleApplicationNode.getName());
        muleApplicationNode.getMuleFlowNodes().forEach(muleFlowNode -> muleFlowNode.accept(this, visitorContext));
        visitorContext.logger().exit(muleApplicationNode.getName());
        return null;
    }

    @Override
    public Object visit(MuleFlowNode muleFlowNode, IncomingAstVisitorContext visitorContext) {
        visitorContext.logger().enter(muleFlowNode.getName());
        visitorContext.setIncomingEventType(new EventType());
        muleFlowNode.getRootMessageProcessorNode().accept(this, visitorContext);
        visitorContext.logger().exit(muleFlowNode.getName());
        return null;
    }
}

