/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MessageProcessorTypeDeclarationAnnotation;
import org.mule.datasense.impl.model.annotations.ResolvedTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.MessageProcessorType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.message.MuleEventMetadataType;

public abstract class BaseTypeResolver
implements TypeResolver {
    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.empty();
    }

    @Override
    public EventType resolveTypes(MessageProcessorNode messageProcessorNode, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        EventType argumentEventType = typingMuleAstVisitorContext.getTypingEnvironment().get().resolveInput();
        EventType resultEventType = this.resolve(messageProcessorNode, argumentEventType, typingMuleAstVisitor, typingMuleAstVisitorContext);
        messageProcessorNode.getAnnotation(MessageProcessorTypeDeclarationAnnotation.class).ifPresent(messageProcessorTypeDeclarationAnnotation -> {
            FunctionType functionType = messageProcessorTypeDeclarationAnnotation.getMessageProcessorTypeDeclaration().getFunctionType();
            functionType.getParameters().stream().map(FunctionParameter::getType).filter(metadataType -> metadataType instanceof MuleEventMetadataType).map(metadataType -> TypeUtils.asEventType((MuleEventMetadataType)metadataType)).findFirst().ifPresent(eventType -> {
                UsesTypeAnnotation usesTypeAnnotation = (UsesTypeAnnotation)messageProcessorNode.getOrCreateAnnotation(UsesTypeAnnotation.class, () -> new UsesTypeAnnotation(new EventType()));
                usesTypeAnnotation.overrideWith((EventType)eventType);
            });
            functionType.getReturnType().filter(metadataType -> metadataType instanceof MuleEventMetadataType).map(metadataType -> TypeUtils.asEventType((MuleEventMetadataType)metadataType)).ifPresent(eventType -> {
                DefinesTypeAnnotation definesTypeAnnotation = (DefinesTypeAnnotation)messageProcessorNode.getOrCreateAnnotation(DefinesTypeAnnotation.class, () -> new DefinesTypeAnnotation(new EventType()));
                definesTypeAnnotation.overrideWith((EventType)eventType);
            });
        });
        EventType usesEventType = messageProcessorNode.getAnnotation(UsesTypeAnnotation.class).map(UsesTypeAnnotation::getUsesEventType).orElse(new EventType());
        EventType definesEventType = messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).map(DefinesTypeAnnotation::getDefinesEventType).orElse(new EventType());
        messageProcessorNode.annotate(new ResolvedTypeAnnotation(new MessageProcessorType(usesEventType, definesEventType, this.isPropagates(messageProcessorNode))));
        resultEventType = messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).map(DefinesTypeAnnotation::getDefinesEventType).orElse(resultEventType);
        resultEventType = this.isPropagates(messageProcessorNode) ? TypeUtils.merge(argumentEventType, resultEventType) : resultEventType;
        return resultEventType;
    }

    protected EventType unifyEventTypes(EventType sourceEventType, EventType targetEventType, boolean source) {
        return source ? sourceEventType : targetEventType;
    }

    protected MessageProcessorType getResolvedType(MessageProcessorNode messageProcessorNode) {
        return messageProcessorNode.getAnnotation(ResolvedTypeAnnotation.class).map(ResolvedTypeAnnotation::getMessageProcessorType).orElse(new MessageProcessorType());
    }

    protected abstract EventType resolve(MessageProcessorNode var1, EventType var2, TypingMuleAstVisitor var3, TypingMuleAstVisitorContext var4);

    protected abstract boolean isPropagates(MessageProcessorNode var1);
}

