/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.MessageProcessorType;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.StructuralNodeTypeResolver;

public abstract class PipedChainTypeResolver
extends StructuralNodeTypeResolver {
    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        List messageProcessorNodes = messageProcessorNode.getMessageProcessorNodes().collect(Collectors.toList());
        Optional<EventType> previousEventType = Optional.empty();
        for (MessageProcessorNode pipedMessageProcessorNode : messageProcessorNodes) {
            EventType pipedInputEvent = previousEventType.isPresent() ? previousEventType.map(eventType -> eventType).orElse(new EventType()) : inputEventType;
            EventType eventType2 = typingMuleAstVisitor.resolveType((AstNode)pipedMessageProcessorNode, pipedInputEvent, typingMuleAstVisitorContext);
            MessageProcessorType functionType = this.getResolvedType(pipedMessageProcessorNode);
            previousEventType = Optional.of(eventType2);
        }
        Stream<VarDecl> outputDeclarations = previousEventType.isPresent() ? ((EventType)previousEventType.get()).getVarDecls() : inputEventType.getVarDecls();
        EventType outputEventType = new EventType(outputDeclarations);
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
        return outputEventType;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

