/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import java.util.Optional;
import org.mule.datasense.api.AnalysisResult;
import org.mule.datasense.api.ComponentPath;
import org.mule.datasense.api.DataSense;
import org.mule.datasense.api.DataSenseInfo;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.extension.DataSenseModuleRegistry;
import org.mule.datasense.impl.ApplicationModelResolver;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.DefaultDataSenseInfo;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.annotators.AnnotatorsRegistry;
import org.mule.datasense.impl.phases.annotators.InfoAnnotator;
import org.mule.datasense.impl.phases.annotators.MessageProcessorTypeDeclarationAnnotator;
import org.mule.datasense.impl.phases.annotators.OperationCallAnnotator;
import org.mule.datasense.impl.phases.annotators.TypeResolverAnnotator;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MuleApplicationNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParser;
import org.mule.datasense.impl.phases.builder.MuleAstParserContext;
import org.mule.datasense.impl.phases.typing.AstTyping;
import org.mule.datasense.impl.phases.typing.resolver.FlowTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.LoggerTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.OperationCallTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.PollTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.ProcessorChainTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SetPayloadAttributesTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SetPayloadTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SetVariableTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TransformTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.tooling.MetadataQuery;
import org.mule.datasense.impl.tooling.MetadataQueryResult;
import org.mule.datasense.impl.tooling.NodeInfoQuery;
import org.mule.datasense.impl.tooling.TypeContextQuery;
import org.mule.datasense.impl.tooling.TypeContextQueryResult;
import org.mule.datasense.impl.tooling.TypeInfoQuery;
import org.mule.datasense.impl.tooling.TypeInfoQueryResult;
import org.mule.datasense.impl.tooling.TypedApplicationQuery;
import org.mule.datasense.impl.tooling.TypedApplicationQueryResult;
import org.mule.datasense.impl.util.AstUtils;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSense
implements DataSense {
    private static final transient Logger logger = LoggerFactory.getLogger(DefaultDataSense.class);
    public static final ComponentIdentifier COMPONENT_IDENTIFIER_FLOW = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "flow");
    public static final ComponentIdentifier COMPONENT_IDENTIFIER_LOGGER = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "logger");
    public static final ComponentIdentifier COMPONENT_IDENTIFIER_POLL = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "poll");
    public static final ComponentIdentifier COMPONENT_IDENTIFIER_TRANSFORM = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "transform");
    public static final ComponentIdentifier COMPONENT_IDENTIFIER_OPERATION_CALL = ComponentIdentifierUtils.createFromNamespaceAndName("internal", "operation-call");
    public static final ComponentIdentifier COMPONENT_IDENTIFIER_SET_PAYLOAD_ATTRIBUTES = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "set-payload-attributes");
    public static final ComponentIdentifier COMPONENT_IDENTIFIER_SET_PAYLOAD = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "set-payload");
    public static final ComponentIdentifier COMPONENT_IDENTIFIER_SET_VARIABLE = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "set-variable");
    public static final ComponentIdentifier COMPONENT_IDENTIFIER_PROCESSOR_CHAIN = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/core", "processor-chain");
    private final DataSenseModuleRegistry dataSenseModuleRegistry = new DataSenseModuleRegistry();

    public static Logger getLogger() {
        return logger;
    }

    private DataSenseModuleRegistry getDataSenseModuleRegistry() {
        return this.dataSenseModuleRegistry;
    }

    protected TypeResolverRegistry createTypeResolverRegistry() {
        TypeResolverRegistry typeResolverRegistry = new TypeResolverRegistry();
        typeResolverRegistry.register(COMPONENT_IDENTIFIER_FLOW, (TypeResolver)new FlowTypeResolver());
        typeResolverRegistry.register(COMPONENT_IDENTIFIER_LOGGER, (TypeResolver)new LoggerTypeResolver());
        typeResolverRegistry.register(COMPONENT_IDENTIFIER_POLL, (TypeResolver)new PollTypeResolver());
        typeResolverRegistry.register(COMPONENT_IDENTIFIER_TRANSFORM, (TypeResolver)new TransformTypeResolver());
        typeResolverRegistry.register(COMPONENT_IDENTIFIER_OPERATION_CALL, (TypeResolver)new OperationCallTypeResolver());
        typeResolverRegistry.register(COMPONENT_IDENTIFIER_SET_PAYLOAD_ATTRIBUTES, (TypeResolver)new SetPayloadAttributesTypeResolver());
        typeResolverRegistry.register(COMPONENT_IDENTIFIER_SET_PAYLOAD, (TypeResolver)new SetPayloadTypeResolver());
        typeResolverRegistry.register(COMPONENT_IDENTIFIER_SET_VARIABLE, (TypeResolver)new SetVariableTypeResolver());
        typeResolverRegistry.register(COMPONENT_IDENTIFIER_PROCESSOR_CHAIN, (TypeResolver)new ProcessorChainTypeResolver());
        return typeResolverRegistry;
    }

    private AnnotatorsRegistry createAnnotatorsRegistry(DataSenseProviderResolver dataSenseProviderResolver, TypeResolverRegistry typeResolverRegistry) {
        AnnotatorsRegistry annotatorsRegistry = new AnnotatorsRegistry();
        annotatorsRegistry.add(new InfoAnnotator());
        annotatorsRegistry.add(new TypeResolverAnnotator(typeResolverRegistry));
        annotatorsRegistry.add(new OperationCallAnnotator());
        annotatorsRegistry.add(new MessageProcessorTypeDeclarationAnnotator());
        return annotatorsRegistry;
    }

    private Optional<MuleApplicationNode> buildMuleApplication(DataSenseProviderResolver dataSenseProviderResolver, ApplicationModel applicationModel, ComponentPath componentPath, TypeResolverRegistry typeResolverRegistry) {
        ComponentModel rootComponentModel = applicationModel.findRootComponentModel();
        MuleAstParser muleAstParser = new MuleAstParser();
        MuleAstParserContext visitorContext = new MuleAstParserContext(componentModel -> {
            ComponentIdentifier identifier = ComponentIdentifierUtils.createFromComponentModel(componentModel);
            ComponentModelType componentModelType = typeResolverRegistry.get(identifier).flatMap(TypeResolver::getComponentModelType).orElse(null);
            if (componentModelType == null) {
                componentModelType = dataSenseProviderResolver.getDslElementModelFactory().create(componentModel.getConfiguration()).map(objectDslElementModel -> {
                    Object model = objectDslElementModel.getModel();
                    if (model instanceof SourceModel) {
                        return ComponentModelType.MESSAGE_SOURCE_NODE;
                    }
                    if (model instanceof OperationModel) {
                        return ComponentModelType.MESSAGE_PROCESSOR_NODE;
                    }
                    return null;
                }).orElse(null);
            }
            return Optional.ofNullable(componentModelType);
        }, componentPath);
        return muleAstParser.parse(rootComponentModel, visitorContext).filter(astNodeBuilder -> astNodeBuilder instanceof MuleApplicationNodeBuilder).map(astNodeBuilder -> ((MuleApplicationNodeBuilder)astNodeBuilder).build());
    }

    @Override
    public Optional<DataSenseInfo> resolve(ComponentPath componentPath, ApplicationModel applicationModel, DataSenseProvider dataSenseProvider) {
        AstNotification astNotification = new AstNotification();
        astNotification.reportInfo(new AstNodeLocation(), I18nMessageFactory.createStaticMessage((String)"Resolving datasense info for component path %s. (build: 4.0.0-M5_95cfe2bbe16800db178c39edac8b80059bf49feb)", (Object[])new Object[]{componentPath}));
        logger.debug("== PARSE " + StringUtils.repeat((String)"-", (int)10));
        ApplicationModelResolver applicationModelResolver = new ApplicationModelResolver(applicationModel);
        TypeResolverRegistry typeResolverRegistry = this.createTypeResolverRegistry();
        DataSenseProviderResolver dataSenseProviderResolver = new DataSenseProviderResolver(dataSenseProvider, applicationModelResolver, astNotification);
        Optional<MuleApplicationNode> muleApplicationNodeOptional = this.buildMuleApplication(dataSenseProviderResolver, applicationModel, componentPath, typeResolverRegistry);
        if (muleApplicationNodeOptional.isPresent()) {
            MuleApplicationNode muleApplicationNode = muleApplicationNodeOptional.get();
            AnnotatorsRegistry annotatorsRegistry = this.createAnnotatorsRegistry(dataSenseProviderResolver, typeResolverRegistry);
            this.process(muleApplicationNode, astNotification, dataSenseProviderResolver, annotatorsRegistry, typeResolverRegistry);
            return this.perform(new NodeInfoQuery(componentPath), muleApplicationNode, dataSenseProviderResolver, astNotification).map(nodeInfoQueryResult -> {
                Optional<TypeInfoQueryResult> typeInfoQueryResult = this.perform(new TypeInfoQuery(componentPath), muleApplicationNode, dataSenseProviderResolver, astNotification);
                Optional<TypeContextQueryResult> typeContextQueryResult = this.perform(new TypeContextQuery(componentPath), muleApplicationNode, dataSenseProviderResolver, astNotification);
                Optional<MetadataQueryResult> metadataQueryResult = this.perform(new MetadataQuery(componentPath), muleApplicationNode, dataSenseProviderResolver, astNotification);
                return new DefaultDataSenseInfo(componentPath, metadataQueryResult.flatMap(MetadataQueryResult::getOperationModel).orElse(null), metadataQueryResult.flatMap(MetadataQueryResult::getSourceModel).orElse(null), (MetadataResult<ComponentMetadataDescriptor>)((MetadataResult)metadataQueryResult.flatMap(MetadataQueryResult::getComponentMetadataDescriptorMetadataResult).orElse(null)), typeInfoQueryResult.flatMap(TypeInfoQueryResult::getInput).orElse(null), typeInfoQueryResult.flatMap(TypeInfoQueryResult::getOutput).orElse(null), typeContextQueryResult.flatMap(TypeContextQueryResult::getIncoming).orElse(null), typeContextQueryResult.flatMap(TypeContextQueryResult::getExpected).orElse(null), astNotification.getPlainMessages());
            });
        }
        throw new RuntimeException(String.format("Failed to resolve datasense info for component path %s. Unable to build datasense model for application.", componentPath));
    }

    private void process(MuleApplicationNode muleApplicationNode, AstNotification astNotification, DataSenseProviderResolver dataSenseProviderResolver, AnnotatorsRegistry annotatorsRegistry, TypeResolverRegistry typeResolverRegistry) {
        if (logger.isDebugEnabled()) {
            logger.debug(StringUtils.repeat((String)"-", (int)10));
            AstUtils.dump(muleApplicationNode);
        }
        AstTyping astTyping = new AstTyping(annotatorsRegistry, typeResolverRegistry);
        if (logger.isDebugEnabled()) {
            logger.debug("== ANNOTATE " + StringUtils.repeat((String)"-", (int)10));
        }
        astTyping.annotate(muleApplicationNode, dataSenseProviderResolver, astNotification);
        if (logger.isDebugEnabled()) {
            logger.debug("== RESOLVE " + StringUtils.repeat((String)"-", (int)10));
        }
        EventType eventType = this.createInitialEvent();
        astTyping.resolveTypes(muleApplicationNode, eventType, astNotification);
        if (logger.isDebugEnabled()) {
            logger.debug(StringUtils.repeat((String)"-", (int)10));
            AstUtils.dump(muleApplicationNode);
            logger.debug("== INCOMING " + StringUtils.repeat((String)"-", (int)10));
        }
        astTyping.generateIncoming(muleApplicationNode, eventType, astNotification);
        if (logger.isDebugEnabled()) {
            logger.debug("== EXPECTED " + StringUtils.repeat((String)"-", (int)10));
        }
        astTyping.generateExpected(muleApplicationNode, eventType, astNotification);
        if (logger.isDebugEnabled()) {
            logger.debug(StringUtils.repeat((String)"-", (int)10));
            AstUtils.dump(muleApplicationNode);
        }
    }

    private EventType createInitialEvent() {
        return TypeUtils.createEventType(null);
    }

    @Override
    public AnalysisResult analyze(DataSenseProvider dataSenseProvider, ApplicationModel applicationModel) {
        return null;
    }

    private <T extends TypedApplicationQueryResult> Optional<T> perform(TypedApplicationQuery<T> typedApplicationQuery, MuleApplicationNode muleApplicationNode, DataSenseProviderResolver dataSenseProviderResolver, AstNotification astNotification) {
        return typedApplicationQuery.perform(muleApplicationNode, dataSenseProviderResolver, astNotification);
    }
}

