/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.datasense.api.ComponentPath;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.BaseAstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.runtime.dsl.api.component.config.ComponentIdentifier;

public class MuleFlowNode
extends BaseAstNode {
    public static final ComponentIdentifier IDENTIFIER = ComponentIdentifier.builder().withNamespace("mule").withName("flow").build();
    private final MessageProcessorNode rootMessageProcessorNode;
    private AstNode parentAstNode;
    private Map<ComponentPath, MessageProcessorNode> messageProcessorNodeMap;

    public MuleFlowNode(ComponentIdentifier componentIdentifier, MessageProcessorNode rootMessageProcessorNode) {
        super(componentIdentifier);
        this.setName(rootMessageProcessorNode.getComponentModel().getNameAttribute());
        Preconditions.checkNotNull((Object)rootMessageProcessorNode);
        this.rootMessageProcessorNode = rootMessageProcessorNode;
        this.messageProcessorNodeMap = new HashMap<ComponentPath, MessageProcessorNode>();
    }

    public AstNode getParentAstNode() {
        return this.parentAstNode;
    }

    public void setParentAstNode(AstNode parentAstNode) {
        this.parentAstNode = parentAstNode;
    }

    public MessageProcessorNode getRootMessageProcessorNode() {
        return this.rootMessageProcessorNode;
    }

    @Override
    public <T> Object accept(AstNodeVisitor<T> astNodeVisitor, T context) {
        return astNodeVisitor.visit(this, context);
    }

    public void register(ComponentPath componentPath, MessageProcessorNode messageProcessorNode) {
        Preconditions.checkState((!this.messageProcessorNodeMap.containsKey(componentPath) ? 1 : 0) != 0, (Object)String.format("Node already registered for componentPath %s", componentPath));
        this.messageProcessorNodeMap.put(componentPath, messageProcessorNode);
    }

    public Optional<MessageProcessorNode> findMessageProcessorNode(ComponentPath componentPath) {
        return Optional.ofNullable(this.messageProcessorNodeMap.get(componentPath));
    }
}

