/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.MessageProcessorType;
import org.mule.datasense.impl.model.types.TypeEquivalence;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.MessageMetadataType;
import org.mule.metadata.message.MessageMetadataTypeBuilder;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;

public class TypeUtils {
    public static boolean isAssignable(MetadataType sourceType, MetadataType targetType) {
        return TypeEquivalence.canBeAssignedTo(sourceType, targetType, null);
    }

    public static Stream<VarDecl> asVarDecls(MuleEventMetadataType muleEventMetadataType) {
        HashSet<VarDecl> varDecls = new HashSet<VarDecl>();
        if (muleEventMetadataType != null) {
            MessageMetadataType messageType = muleEventMetadataType.getMessageType();
            if (messageType.getPayloadType().isPresent() || messageType.getAttributesType().isPresent()) {
                varDecls.add(new VarDecl("#message#", (MetadataType)messageType));
            }
            muleEventMetadataType.getVariables().getFields().forEach(objectFieldType -> varDecls.add(new VarDecl(objectFieldType.getKey().getName().getLocalPart(), objectFieldType.getValue())));
        }
        return varDecls.stream();
    }

    public static MuleEventMetadataTypeBuilder asMuleEventMetadataType(EventType eventType) {
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = MuleEventMetadataType.builder();
        if (eventType.getVarDecls() != null) {
            eventType.getVarDecls().forEach(dataDeclaration -> {
                MetadataType metadataType = dataDeclaration.getType();
                if (dataDeclaration.getName().equals("#message#")) {
                    if (!(metadataType instanceof MessageMetadataType)) throw new IllegalArgumentException("Expected MessageMetadataType but find " + metadataType.getClass());
                    MessageMetadataType messageMetadataType = (MessageMetadataType)metadataType;
                    messageMetadataType.getPayloadType().ifPresent(payloadMetadataType -> muleEventMetadataTypeBuilder.message().payload(payloadMetadataType));
                    messageMetadataType.getAttributesType().ifPresent(attributesType -> muleEventMetadataTypeBuilder.message().attributes(attributesType));
                    return;
                } else {
                    muleEventMetadataTypeBuilder.addVariable(dataDeclaration.getName(), metadataType);
                }
            });
        }
        return muleEventMetadataTypeBuilder;
    }

    public static FunctionType asMetadataType(MessageProcessorType messageProcessorType) {
        if (messageProcessorType == null) {
            return null;
        }
        FunctionTypeBuilder functionTypeBuilder = TypesHelper.getTypeBuilder().functionType().addParameterOf("input", (TypeBuilder)TypeUtils.asMuleEventMetadataType(messageProcessorType.getInputEventType())).returnType((TypeBuilder)TypeUtils.asMuleEventMetadataType(messageProcessorType.getOutputEventType()));
        return functionTypeBuilder.build();
    }

    public static EventType asEventType(MuleEventMetadataType muleEventMetadataType) {
        return new EventType(TypeUtils.asVarDecls(muleEventMetadataType));
    }

    public static MessageProcessorType asMessageProcessorType(MuleEventMetadataType inputMuleEventMetadataType, MuleEventMetadataType outputMuleEventMetadataType, boolean propagates) {
        return new MessageProcessorType(TypeUtils.asEventType(inputMuleEventMetadataType), TypeUtils.asEventType(outputMuleEventMetadataType), propagates);
    }

    public static MuleEventMetadataType getMessageProcessorInputType(FunctionType messageProcessorFunctionType) {
        Preconditions.checkNotNull((Object)messageProcessorFunctionType);
        if (messageProcessorFunctionType.getParameters().size() >= 1) {
            FunctionParameter functionParameter = (FunctionParameter)messageProcessorFunctionType.getParameters().get(0);
            MetadataType metadataType = functionParameter.getType();
            if (metadataType instanceof MuleEventMetadataType) {
                return (MuleEventMetadataType)metadataType;
            }
            throw new IllegalArgumentException("MuleEvent metadata type expected.");
        }
        throw new IllegalArgumentException("Input parameter not defined.");
    }

    public static MuleEventMetadataType getMessageProcessorOutputType(FunctionType messageProcessorFunctionType) {
        Preconditions.checkNotNull((Object)messageProcessorFunctionType);
        Optional result = Optional.empty();
        Optional metadataTypeOptional = messageProcessorFunctionType.getReturnType();
        if (metadataTypeOptional.isPresent()) {
            MetadataType metadataType = (MetadataType)metadataTypeOptional.get();
            if (metadataType instanceof MuleEventMetadataType) {
                return (MuleEventMetadataType)metadataType;
            }
            throw new IllegalArgumentException("MuleEvent metadata type expected.");
        }
        throw new IllegalArgumentException("Return not defined.");
    }

    public static EventType merge(EventType eventType1, EventType eventType2) {
        if (eventType1 == null) {
            return eventType2;
        }
        if (eventType2 == null) {
            return eventType1;
        }
        Set collect = eventType2.getVarDecls().collect(Collectors.toSet());
        collect.addAll(eventType1.getVarDecls().collect(Collectors.toSet()));
        return new EventType(collect.stream());
    }

    public static MetadataType override(MetadataType metadataType1, MetadataType metadataType2) {
        MetadataType result;
        if (metadataType1 == null) {
            return metadataType2;
        }
        if (metadataType2 == null) {
            return metadataType1;
        }
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
        if (metadataType1 instanceof MessageMetadataType) {
            MessageMetadataType messageMetadataType1 = (MessageMetadataType)metadataType1;
            if (metadataType2 instanceof MessageMetadataType) {
                MetadataType attributesMetadataType;
                MessageMetadataType messageMetadataType2 = (MessageMetadataType)metadataType2;
                MetadataType payloadMetadataType = messageMetadataType2.getPayloadType().orElse(messageMetadataType1.getPayloadType().orElse(null));
                if (payloadMetadataType != null) {
                    messageMetadataTypeBuilder.payload(payloadMetadataType);
                }
                if ((attributesMetadataType = (MetadataType)messageMetadataType2.getAttributesType().orElse(messageMetadataType1.getAttributesType().orElse(null))) != null) {
                    messageMetadataTypeBuilder.attributes(attributesMetadataType);
                }
            } else {
                messageMetadataTypeBuilder.payload(metadataType2);
                messageMetadataType1.getAttributesType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)messageMetadataTypeBuilder).attributes(arg_0));
            }
            result = messageMetadataTypeBuilder.build();
        } else {
            result = metadataType2;
        }
        return result;
    }

    public static EventType override(EventType eventType1, EventType eventType2) {
        if (eventType1 == null) {
            return eventType2;
        }
        if (eventType2 == null) {
            return eventType1;
        }
        HashMap varDecls = new HashMap();
        eventType1.getVarDecls().forEach(varDecl -> varDecls.put(varDecl.getName(), varDecl));
        eventType2.getVarDecls().forEach(varDecl -> {
            VarDecl overridenVarDecl = (VarDecl)varDecls.get(varDecl.getName());
            if (overridenVarDecl != null) {
                varDecls.put(overridenVarDecl.getName(), new VarDecl(overridenVarDecl.getName(), TypeUtils.override(overridenVarDecl.getType(), varDecl.getType())));
            } else {
                varDecls.put(varDecl.getName(), varDecl);
            }
        });
        return new EventType(varDecls.values().stream());
    }

    public static EventType createEventType(MetadataType metadataType) {
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        if (metadataType != null) {
            muleEventMetadataTypeBuilder.message().payload(metadataType);
        }
        MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
        return TypeUtils.asEventType(muleEventMetadataType);
    }
}

