/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.api.metadataprovider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.BaseApplicationModelFactory;
import org.mule.datasense.api.metadataprovider.DefaultApplicationModel;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.config.api.dsl.processor.ConfigLine;

public class ApplicationModelFromUrl
extends BaseApplicationModelFactory {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private static final String MULE_DEPLOY_PROPERTIES = "mule-deploy.properties";
    private static final String CONFIG_RESOURCES = "config.resources";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readToBuffer(URL url) throws IOException {
        byte[] byArray;
        BufferedInputStream inputStream = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(5000);
            urlConnection.setReadTimeout(5000);
            inputStream = new BufferedInputStream(urlConnection.getInputStream());
            ByteArrayOutputStream bufferOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)bufferOutputStream);
            byArray = bufferOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return byArray;
    }

    private Optional<Stream<String>> findConfigsFromDeployProperties(byte[] buffer) throws IOException {
        ZipEntry entry;
        Optional<Stream<String>> configsOptional = Optional.empty();
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(buffer));
        while ((entry = zipInputStream.getNextEntry()) != null) {
            if (!MULE_DEPLOY_PROPERTIES.equals(entry.getName())) continue;
            Properties properties = new Properties();
            properties.load(zipInputStream);
            String configResources = properties.getProperty(CONFIG_RESOURCES);
            if (configResources == null) break;
            configsOptional = Optional.of(Stream.of(StringUtils.split((String)configResources, (String)",")));
            break;
        }
        return configsOptional;
    }

    private Optional<org.mule.runtime.config.api.dsl.model.ApplicationModel> readConfigs(Stream<String> configs, byte[] buffer) throws IOException {
        ZipEntry entry;
        Optional<org.mule.runtime.config.api.dsl.model.ApplicationModel> result = Optional.empty();
        Set configsSet = configs.collect(Collectors.toSet());
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(buffer));
        while ((entry = zipInputStream.getNextEntry()) != null) {
            if (!configsSet.contains(entry.getName())) continue;
            result = this.loadConfigLines(zipInputStream).map(configLine -> {
                try {
                    return this.loadApplicationModel((ConfigLine)configLine);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
            break;
        }
        return result;
    }

    private Optional<org.mule.runtime.config.api.dsl.model.ApplicationModel> processZip(byte[] buffer) throws IOException {
        return this.findConfigsFromDeployProperties(buffer).map(configs -> {
            try {
                return this.readConfigs((Stream<String>)configs, buffer);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }).orElse(Optional.empty());
    }

    public Optional<ApplicationModel> create(URL url) throws Exception {
        return this.processZip(this.readToBuffer(url)).map(applicationModel -> new DefaultApplicationModel(url.getFile(), (org.mule.runtime.config.api.dsl.model.ApplicationModel)applicationModel));
    }
}

