/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.api.metadataprovider;

import java.util.Optional;
import java.util.Set;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.enrichment.model.IdComponentModelSelector;
import org.mule.datasense.impl.DataSenseApplicationModel;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.api.dsl.model.ComponentModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedDataSenseProvider
implements DataSenseProvider {
    static final transient Logger logger = LoggerFactory.getLogger(CachedDataSenseProvider.class);
    private final DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider;
    private final DataSenseApplicationModel dataSenseApplicationModel;
    private final ApplicationModel applicationModel;
    private final DataSenseProvider delegate;

    public CachedDataSenseProvider(ApplicationModel applicationModel, DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider, DataSenseProvider delegate) {
        this.dataSenseApplicationModel = this.createDataSenseApplicationModel(applicationModel, delegate);
        this.applicationModel = applicationModel;
        this.delegate = delegate;
        this.dataSenseMetadataCacheProvider = dataSenseMetadataCacheProvider;
    }

    @Override
    public Set<ExtensionModel> getExtensions() {
        return this.delegate.getExtensions();
    }

    private DataSenseApplicationModel createDataSenseApplicationModel(ApplicationModel applicationModel, DataSenseProvider delegate) {
        AstNotification astNotification = new AstNotification();
        DataSenseApplicationModel dataSenseApplicationModel = new DataSenseApplicationModel(null, applicationModel, delegate, astNotification);
        dataSenseApplicationModel.build();
        return dataSenseApplicationModel;
    }

    @Override
    public Optional<DataSenseMetadataProvider> getDataSenseMetadataProvider() {
        return this.delegate.getDataSenseMetadataProvider().map(dataSenseMetadataProvider -> new CachedDataSenseMetadataProvider((DataSenseMetadataProvider)dataSenseMetadataProvider, this.dataSenseMetadataCacheProvider));
    }

    private class CachedDataSenseMetadataProvider
    implements DataSenseMetadataProvider {
        private final DataSenseMetadataProvider delegate;
        private final DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider;

        public CachedDataSenseMetadataProvider(DataSenseMetadataProvider delegate, DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider) {
            this.delegate = delegate;
            this.dataSenseMetadataCacheProvider = dataSenseMetadataCacheProvider;
        }

        public DataSenseMetadataProvider getDelegate() {
            return this.delegate;
        }

        @Override
        public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(Location location) {
            try {
                ComponentModel componentModel = this.getComponentModel(location);
                return this.dataSenseMetadataCacheProvider.getOperationMetadata(this.getComponentId(componentModel), location, this.resolveEffectiveTimestamp(componentModel), () -> Optional.ofNullable(this.getDelegate().getOperationMetadata(location)).orElseThrow(() -> new RuntimeException(String.format("Failed to resolve operation metadata for component path %s.", location))));
            }
            catch (Exception e) {
                logger.error(String.format("Failed to resolve operation metadata for component path %s.", location), (Throwable)e);
                return null;
            }
        }

        @Override
        public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(Location location) {
            try {
                ComponentModel componentModel = this.getComponentModel(location);
                return this.dataSenseMetadataCacheProvider.getSourceMetadata(this.getComponentId(componentModel), location, this.resolveEffectiveTimestamp(componentModel), () -> Optional.ofNullable(this.getDelegate().getSourceMetadata(location)).orElseThrow(() -> new RuntimeException(String.format("Failed to resolve source metadata for component path %s.", location))));
            }
            catch (Exception e) {
                logger.error(String.format("Failed to resolve source metadata for component path %s.", location), (Throwable)e);
                return null;
            }
        }

        @Override
        public MetadataResult<MetadataKeysContainer> getMetadataKeys(Location location) {
            try {
                ComponentModel componentModel = this.getComponentModel(location);
                return this.dataSenseMetadataCacheProvider.getMetadataKeys(this.getComponentId(componentModel), location, this.resolveEffectiveTimestamp(componentModel), () -> Optional.ofNullable(this.getDelegate().getMetadataKeys(location)).orElseThrow(() -> new RuntimeException(String.format("Failed to resolve metadata keys for component path %s.", location))));
            }
            catch (Exception e) {
                logger.error(String.format("Failed to resolve metadata keys for component path %s.", location), (Throwable)e);
                return null;
            }
        }

        private Optional<Long> resolveTimestamp(ComponentModel componentModel) {
            if (componentModel == null) {
                return Optional.empty();
            }
            try {
                return Optional.of(Long.parseLong((String)componentModel.getParameters().get("doc:timestamp")));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }

        private Optional<String> getConfigurationRef(ComponentModel componentModel) {
            return Optional.ofNullable(componentModel.getParameters().get("config-ref"));
        }

        private ComponentModel getComponentModel(Location location) {
            return CachedDataSenseProvider.this.dataSenseApplicationModel.find(location).orElseThrow(() -> new RuntimeException(String.format("Component path %s not found on app.", location)));
        }

        private String getComponentId(ComponentModel componentModel) {
            return IdComponentModelSelector.getComponentId((ComponentModel)componentModel);
        }

        private Long resolveEffectiveTimestamp(ComponentModel componentModel) {
            Long componentTimestamp = this.resolveTimestamp(componentModel).orElse(null);
            Optional relatedConfigurationOptional = this.getConfigurationRef(componentModel).flatMap(CachedDataSenseProvider.this.applicationModel::findNamedComponent);
            if (relatedConfigurationOptional.isPresent()) {
                Long configurationTimestamp = this.resolveTimestamp((ComponentModel)relatedConfigurationOptional.get()).orElse(null);
                return componentTimestamp != null && configurationTimestamp != null ? Long.valueOf(Long.max(componentTimestamp, configurationTimestamp)) : null;
            }
            return componentTimestamp;
        }
    }
}

