/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.datasense.api.DataSenseResolutionScope;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.ApplicationModelResolver;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.annotators.AnnotatorsRegistry;
import org.mule.datasense.impl.phases.annotators.InfoAnnotator;
import org.mule.datasense.impl.phases.annotators.MessageProcessorTypeDeclarationAnnotator;
import org.mule.datasense.impl.phases.annotators.OperationCallAnnotator;
import org.mule.datasense.impl.phases.annotators.TypeResolverAnnotator;
import org.mule.datasense.impl.phases.annotators.UnknownTypeResolverAnnotator;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MuleApplicationNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParser;
import org.mule.datasense.impl.phases.builder.MuleAstParserContext;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.AstTyping;
import org.mule.datasense.impl.phases.typing.resolver.DataSenseTypeResolverRegistry;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.util.AstUtils;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.config.api.dsl.model.ComponentModel;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transformer.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSenseApplicationModel {
    private static final transient Logger logger = LoggerFactory.getLogger(DataSenseApplicationModel.class);
    private final DataSenseResolutionScope dataSenseResolutionScope;
    private final DataSenseProvider dataSenseProvider;
    private final AstNotification astNotification;
    private ApplicationModel applicationModel;
    private MuleApplicationNode muleApplicationNode;
    private DataSenseProviderResolver dataSenseProviderResolver;
    private TypeResolverRegistry typeResolverRegistry;

    public DataSenseApplicationModel(DataSenseResolutionScope dataSenseResolutionScope, ApplicationModel applicationModel, DataSenseProvider dataSenseProvider, AstNotification astNotification) {
        this(dataSenseResolutionScope, applicationModel, dataSenseProvider, new DataSenseTypeResolverRegistry(), astNotification);
    }

    public DataSenseApplicationModel(DataSenseResolutionScope dataSenseResolutionScope, ApplicationModel applicationModel, DataSenseProvider dataSenseProvider, TypeResolverRegistry typeResolverRegistry, AstNotification astNotification) {
        this.dataSenseResolutionScope = dataSenseResolutionScope;
        this.applicationModel = applicationModel;
        this.dataSenseProvider = dataSenseProvider;
        this.typeResolverRegistry = typeResolverRegistry;
        this.astNotification = astNotification;
    }

    public void build() {
        ApplicationModelResolver applicationModelResolver = new ApplicationModelResolver(this.applicationModel);
        this.dataSenseProviderResolver = new DataSenseProviderResolver(this.dataSenseProvider, applicationModelResolver, this.astNotification);
        ComponentModel rootComponentModel = this.applicationModel.findRootComponentModel();
        this.parse(rootComponentModel);
    }

    private void parse(ComponentModel rootComponentModel) {
        MuleAstParser muleAstParser = new MuleAstParser();
        MuleAstParserContext visitorContext = new MuleAstParserContext(componentModel -> {
            Class parsedComponentModelType;
            ComponentIdentifier identifier = ComponentIdentifierUtils.createFromComponentModel(componentModel);
            ComponentModelType componentModelType = this.typeResolverRegistry.get(identifier).flatMap(TypeResolver::getComponentModelType).orElse(null);
            if (componentModelType == null) {
                componentModelType = this.dataSenseProviderResolver.getDslElementModelFactory().create(componentModel.getConfiguration()).map(objectDslElementModel -> {
                    Object model = objectDslElementModel.getModel();
                    if (model instanceof SourceModel) {
                        return ComponentModelType.MESSAGE_SOURCE_NODE;
                    }
                    if (model instanceof OperationModel) {
                        return ComponentModelType.MESSAGE_PROCESSOR_NODE;
                    }
                    return null;
                }).orElse(null);
            }
            if (componentModelType == null && (parsedComponentModelType = componentModel.getType()) != null && (Transformer.class.isAssignableFrom(parsedComponentModelType) || Processor.class.isAssignableFrom(parsedComponentModelType))) {
                componentModelType = ComponentModelType.MESSAGE_PROCESSOR_NODE;
            }
            return Optional.ofNullable(componentModelType);
        }, this.dataSenseResolutionScope, this.typeResolverRegistry);
        this.muleApplicationNode = muleAstParser.parse(rootComponentModel, visitorContext).filter(astNodeBuilder -> astNodeBuilder instanceof MuleApplicationNodeBuilder).map(astNodeBuilder -> ((MuleApplicationNodeBuilder)astNodeBuilder).build()).orElseThrow(() -> new RuntimeException("Failed to build application model."));
        AnnotatorsRegistry annotatorsRegistry = new AnnotatorsRegistry();
        annotatorsRegistry.add(new InfoAnnotator());
        AstTyping astTyping = new AstTyping(annotatorsRegistry, this.typeResolverRegistry);
        astTyping.annotate(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
    }

    private AnnotatorsRegistry createAnnotatorsRegistry() {
        AnnotatorsRegistry annotatorsRegistry = new AnnotatorsRegistry();
        annotatorsRegistry.add(new TypeResolverAnnotator(this.typeResolverRegistry));
        annotatorsRegistry.add(new OperationCallAnnotator());
        annotatorsRegistry.add(new UnknownTypeResolverAnnotator());
        annotatorsRegistry.add(new MessageProcessorTypeDeclarationAnnotator());
        return annotatorsRegistry;
    }

    public void resolve() {
        AnnotatorsRegistry annotatorsRegistry = this.createAnnotatorsRegistry();
        if (logger.isDebugEnabled()) {
            logger.debug(StringUtils.repeat((String)"-", (int)10));
            AstUtils.dump(this.muleApplicationNode);
        }
        AstTyping astTyping = new AstTyping(annotatorsRegistry, this.typeResolverRegistry);
        if (logger.isDebugEnabled()) {
            logger.debug("== ANNOTATE " + StringUtils.repeat((String)"-", (int)10));
        }
        astTyping.annotate(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
        if (logger.isDebugEnabled()) {
            logger.debug("== RESOLVE " + StringUtils.repeat((String)"-", (int)10));
        }
        EventType eventType = this.createInitialEvent();
        astTyping.resolveTypes(this.muleApplicationNode, eventType, this.astNotification);
        if (logger.isDebugEnabled()) {
            logger.debug(StringUtils.repeat((String)"-", (int)10));
            AstUtils.dump(this.muleApplicationNode);
            logger.debug("== INCOMING " + StringUtils.repeat((String)"-", (int)10));
        }
        astTyping.generateIncoming(this.muleApplicationNode, eventType, this.astNotification);
        if (logger.isDebugEnabled()) {
            logger.debug("== EXPECTED " + StringUtils.repeat((String)"-", (int)10));
        }
        astTyping.generateExpected(this.muleApplicationNode, eventType, this.astNotification);
        if (logger.isDebugEnabled()) {
            logger.debug(StringUtils.repeat((String)"-", (int)10));
            AstUtils.dump(this.muleApplicationNode);
        }
    }

    public boolean resolveComponent(Location location) {
        return this.findMessageProcessorNode(location).flatMap(messageProcessorNode -> {
            AnnotatorsRegistry annotatorsRegistry = this.createAnnotatorsRegistry();
            String flowName = location.getGlobalName();
            return this.muleApplicationNode.findMuleFlowNode(flowName).map(muleFlowNode -> {
                AnnotatingMuleAstVisitor annotatingMuleAstVisitor = new AnnotatingMuleAstVisitor(annotatorsRegistry);
                AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext = new AnnotatingMuleAstVisitorContext(this.astNotification, this.dataSenseProviderResolver);
                annotatingMuleAstVisitorContext.annotate(new MuleFlowAnnotation((MuleFlowNode)muleFlowNode));
                annotatingMuleAstVisitor.annotate((AstNode)messageProcessorNode, annotatingMuleAstVisitorContext);
                return true;
            });
        }).orElse(false);
    }

    private EventType createInitialEvent() {
        return TypeUtils.createEventType(null);
    }

    public Optional<ComponentModel> find(Location location) {
        return this.findMessageProcessorNode(location).map(MessageProcessorNode::getComponentModel);
    }

    public Optional<MessageProcessorNode> findMessageProcessorNode(Location location) {
        return this.muleApplicationNode.findMessageProcessorNode(location);
    }

    public MuleApplicationNode getMuleApplicationNode() {
        return this.muleApplicationNode;
    }

    public DataSenseProviderResolver getDataSenseProviderResolver() {
        return this.dataSenseProviderResolver;
    }
}

