/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.StructuralNodeTypeResolver;
import org.mule.datasense.impl.util.MutableHolder;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.api.dsl.model.ComponentModel;

public abstract class ScopeTypeResolver
extends StructuralNodeTypeResolver {
    private final ComponentIdentifier componentIdentiferScopeIn;
    private final ComponentIdentifier componentIdentiferScopeOut;

    public ScopeTypeResolver(ComponentIdentifier componentIdentiferScopeIn, ComponentIdentifier componentIdentiferScopeOut) {
        Preconditions.checkNotNull((Object)componentIdentiferScopeIn, (String)"ScopeIn identifier not provided.");
        Preconditions.checkNotNull((Object)componentIdentiferScopeOut, (String)"ScopeIn identifier not provided.");
        this.componentIdentiferScopeIn = componentIdentiferScopeIn;
        this.componentIdentiferScopeOut = componentIdentiferScopeOut;
    }

    public ComponentIdentifier getComponentIdentiferScopeIn() {
        return this.componentIdentiferScopeIn;
    }

    public ComponentIdentifier getComponentIdentiferScopeOut() {
        return this.componentIdentiferScopeOut;
    }

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return false;
    }

    @Override
    protected boolean isScope() {
        return true;
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        List messageProcessorNodes = messageProcessorNode.getMessageProcessorNodes().collect(Collectors.toList());
        MutableHolder<EventType> previousEventType = new MutableHolder<EventType>();
        for (MessageProcessorNode pipedMessageProcessorNode : messageProcessorNodes) {
            EventType pipedInputEvent = previousEventType.getValue().orElse(inputEventType);
            EventType eventType2 = typingMuleAstVisitor.resolveType((AstNode)pipedMessageProcessorNode, pipedInputEvent, typingMuleAstVisitorContext);
            previousEventType.setValue(eventType2);
        }
        EventType outputEventType = new EventType(previousEventType.getValue().map(eventType -> eventType.getVarDecls()).orElse(inputEventType.getVarDecls()));
        return outputEventType;
    }

    @Override
    public Optional<MuleAstParseProvider> getParseProvider() {
        return Optional.of((componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders, muleAstParserContext) -> this.generateAst(componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders));
    }

    private static Stream<MessageProcessorNode> getMessageProcessorNodeWithComponentIdentifier(MessageProcessorNode messageProcessorNode, ComponentIdentifier componentIdentifier) {
        return messageProcessorNode.getMessageProcessorNodes().filter(childMessageProcessorNode -> childMessageProcessorNode.getComponentIdentifier().equals(componentIdentifier));
    }

    public Optional<MessageProcessorNode> getScopeInMessageProcessorNode(MessageProcessorNode messageProcessorNode) {
        return ScopeTypeResolver.getMessageProcessorNodeWithComponentIdentifier(messageProcessorNode, this.getComponentIdentiferScopeIn()).findFirst();
    }

    public Optional<MessageProcessorNode> getScopeOutMessageProcessorNode(MessageProcessorNode messageProcessorNode) {
        return ScopeTypeResolver.getMessageProcessorNodeWithComponentIdentifier(messageProcessorNode, this.getComponentIdentiferScopeOut()).findFirst();
    }

    private Optional<AstNodeBuilder> generateAst(ComponentIdentifier componentIdentifier, ComponentModel componentModel, ComponentModelType componentModelType, List<MessageProcessorNodeBuilder> messageProcessorNodeBuilders) {
        MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
        messageProcessorNodeBuilder.config(componentModel);
        messageProcessorNodeBuilder.componentModelType(componentModelType);
        messageProcessorNodeBuilder.messageProcessor(this.getComponentIdentiferScopeIn(), m -> {
            m.config(componentModel);
            m.synthetic();
        });
        messageProcessorNodeBuilders.forEach(messageProcessorNodeBuilder::messageProcessor);
        messageProcessorNodeBuilder.messageProcessor(this.getComponentIdentiferScopeOut(), m -> {
            m.config(componentModel);
            m.synthetic();
        });
        return Optional.of(messageProcessorNodeBuilder);
    }

    protected static class ScopeOut
    extends SingleNodeTypeResolver {
        protected ScopeOut() {
        }

        @Override
        protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
            EventType eventType = visitorContext.getAnnotation(MuleFlowAnnotation.class).map(MuleFlowAnnotation::getMuleFlowNode).flatMap(muleFlowNode -> muleFlowNode.getAnnotation(DefinesTypeAnnotation.class)).map(definesTypeAnnotation -> definesTypeAnnotation.getDefinesEventType()).orElse(new EventType());
            messageProcessorNode.annotate(new UsesTypeAnnotation(eventType));
            return inputEventType;
        }

        @Override
        protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
            return true;
        }
    }

    protected static class ScopeIn
    extends SingleNodeTypeResolver {
        protected ScopeIn() {
        }

        @Override
        protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
            inputEventType = visitorContext.getAnnotation(MuleFlowAnnotation.class).map(MuleFlowAnnotation::getMuleFlowNode).flatMap(muleFlowNode -> muleFlowNode.getAnnotation(UsesTypeAnnotation.class)).map(usesTypeAnnotation -> usesTypeAnnotation.getUsesEventType()).orElse(inputEventType);
            messageProcessorNode.annotate(new DefinesTypeAnnotation(inputEventType));
            return inputEventType;
        }

        @Override
        protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
            return true;
        }
    }
}

