/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import java.util.function.Consumer;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SetDataTypeResolver;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;

public class SetVariableTypeResolver
extends SetDataTypeResolver {
    private static final String FIELD_VALUE = "value";
    private static final String FIELD_VARIABLE = "variableName";
    private static final String TYPE_DEFAULT_EXPRESSION = "''";

    @Override
    protected Consumer<MuleEventExprBuilder> getMuleEventExprBuilderConsumer(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        return muleEventExprBuilder -> this.getVarDeclName(messageProcessorNode).ifPresent(variableName -> {
            String expression = this.getVarDeclValue(messageProcessorNode);
            muleEventExprBuilder.variable((String)variableName, v -> v.value(new ValueExprBuilder(new SimpleExprBuilder(expression))));
        });
    }

    protected Optional<String> getVarDeclName(MessageProcessorNode messageProcessorNode) {
        return Optional.ofNullable(messageProcessorNode.getComponentModel().getParameters().get(FIELD_VARIABLE));
    }

    protected String getVarDeclValue(MessageProcessorNode messageProcessorNode) {
        return ExpressionLanguageUtils.extractExpression((String)messageProcessorNode.getComponentModel().getParameters().get(FIELD_VALUE)).orElse(TYPE_DEFAULT_EXPRESSION);
    }
}

