/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.api.model.impl.DefaultAttributeFieldType;
import org.mule.metadata.api.model.impl.DefaultAttributeKeyType;
import org.mule.metadata.api.model.impl.DefaultBinaryType;
import org.mule.metadata.api.model.impl.DefaultBooleanType;
import org.mule.metadata.api.model.impl.DefaultDateTimeType;
import org.mule.metadata.api.model.impl.DefaultDateType;
import org.mule.metadata.api.model.impl.DefaultFunctionType;
import org.mule.metadata.api.model.impl.DefaultIntersectionType;
import org.mule.metadata.api.model.impl.DefaultLocalDateTimeType;
import org.mule.metadata.api.model.impl.DefaultLocalTimeType;
import org.mule.metadata.api.model.impl.DefaultNothingType;
import org.mule.metadata.api.model.impl.DefaultNullType;
import org.mule.metadata.api.model.impl.DefaultNumberType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectKeyType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultPeriodType;
import org.mule.metadata.api.model.impl.DefaultRegexType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.model.impl.DefaultTimeType;
import org.mule.metadata.api.model.impl.DefaultTimeZoneType;
import org.mule.metadata.api.model.impl.DefaultTupleType;
import org.mule.metadata.api.model.impl.DefaultTypeParameterType;
import org.mule.metadata.api.model.impl.DefaultUnionType;
import org.mule.metadata.api.model.impl.DefaultVoidType;

public class MetadataTypeTransform {
    public MetadataType transform(MetadataType metadataType) {
        if (metadataType instanceof DefaultAnyType) {
            return this.visitAnyType((DefaultAnyType)metadataType);
        }
        if (metadataType instanceof DefaultArrayType) {
            return this.visitArrayType((DefaultArrayType)metadataType);
        }
        if (metadataType instanceof DefaultBinaryType) {
            return this.transformBinaryType((DefaultBinaryType)metadataType);
        }
        if (metadataType instanceof DefaultBooleanType) {
            return this.transformBoolean((DefaultBooleanType)metadataType);
        }
        if (metadataType instanceof DefaultDateTimeType) {
            return this.visitDateTime((DefaultDateTimeType)metadataType);
        }
        if (metadataType instanceof DefaultDateType) {
            return this.visitDate((DefaultDateType)metadataType);
        }
        if (metadataType instanceof DefaultNullType) {
            return this.visitNull((DefaultNullType)metadataType);
        }
        if (metadataType instanceof DefaultVoidType) {
            return this.visitVoid((DefaultVoidType)metadataType);
        }
        if (metadataType instanceof DefaultNumberType) {
            return this.visitNumber((DefaultNumberType)metadataType);
        }
        if (metadataType instanceof DefaultObjectType) {
            return this.visitObject((DefaultObjectType)metadataType);
        }
        if (metadataType instanceof DefaultStringType) {
            return this.visitString((DefaultStringType)metadataType);
        }
        if (metadataType instanceof DefaultTimeType) {
            return this.visitTime((DefaultTimeType)metadataType);
        }
        if (metadataType instanceof DefaultTupleType) {
            return this.visitTuple((DefaultTupleType)metadataType);
        }
        if (metadataType instanceof DefaultUnionType) {
            return this.visitUnion((DefaultUnionType)metadataType);
        }
        if (metadataType instanceof DefaultIntersectionType) {
            return this.visitIntersection((DefaultIntersectionType)metadataType);
        }
        if (metadataType instanceof DefaultObjectKeyType) {
            return this.visitObjectKey((DefaultObjectKeyType)metadataType);
        }
        if (metadataType instanceof DefaultAttributeKeyType) {
            return this.visitAttributeKey((DefaultAttributeKeyType)metadataType);
        }
        if (metadataType instanceof DefaultAttributeFieldType) {
            return this.visitAttributeField((DefaultAttributeFieldType)metadataType);
        }
        if (metadataType instanceof DefaultObjectFieldType) {
            return this.visitObjectField((DefaultObjectFieldType)metadataType);
        }
        if (metadataType instanceof DefaultNothingType) {
            return this.visitNothing((DefaultNothingType)metadataType);
        }
        if (metadataType instanceof DefaultFunctionType) {
            return this.visitFunction((DefaultFunctionType)metadataType);
        }
        if (metadataType instanceof DefaultLocalDateTimeType) {
            return this.visitLocalDateTime((DefaultLocalDateTimeType)metadataType);
        }
        if (metadataType instanceof DefaultLocalTimeType) {
            return this.visitLocalTime((DefaultLocalTimeType)metadataType);
        }
        if (metadataType instanceof DefaultPeriodType) {
            return this.visitPeriod((DefaultPeriodType)metadataType);
        }
        if (metadataType instanceof DefaultRegexType) {
            return this.visitRegex((DefaultRegexType)metadataType);
        }
        if (metadataType instanceof DefaultTimeZoneType) {
            return this.visitTimeZone((DefaultTimeZoneType)metadataType);
        }
        if (metadataType instanceof DefaultTypeParameterType) {
            return this.visitTypeParameter((DefaultTypeParameterType)metadataType);
        }
        throw new IllegalArgumentException();
    }

    private Map<Class<? extends TypeAnnotation>, TypeAnnotation> getExtensions(BaseMetadataType metadataType) {
        HashMap<Class<? extends TypeAnnotation>, TypeAnnotation> result = new HashMap<Class<? extends TypeAnnotation>, TypeAnnotation>();
        metadataType.getAnnotations().forEach(typeAnnotation -> result.put((Class<? extends TypeAnnotation>)typeAnnotation.getClass(), (TypeAnnotation)typeAnnotation));
        return result;
    }

    private MetadataType visitAnyType(DefaultAnyType anyType) {
        return this.transformAnyType(anyType.getMetadataFormat(), this.getExtensions((BaseMetadataType)anyType));
    }

    protected MetadataType transformAnyType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultAnyType(metadataFormat, extensions);
    }

    private MetadataType visitArrayType(DefaultArrayType arrayType) {
        return this.transformArrayType(() -> this.transform(arrayType.getType()), arrayType.getMetadataFormat(), this.getExtensions((BaseMetadataType)arrayType));
    }

    protected MetadataType transformArrayType(Supplier<MetadataType> type, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultArrayType(type, metadataFormat, extensions);
    }

    private MetadataType transformBinaryType(DefaultBinaryType binaryType) {
        return this.transformBinaryType(binaryType.getMetadataFormat(), this.getExtensions((BaseMetadataType)binaryType));
    }

    protected MetadataType transformBinaryType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultBinaryType(metadataFormat, extensions);
    }

    private MetadataType transformBoolean(DefaultBooleanType booleanType) {
        return this.transformBoolean(booleanType.getMetadataFormat(), this.getExtensions((BaseMetadataType)booleanType));
    }

    protected MetadataType transformBoolean(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultBooleanType(metadataFormat, extensions);
    }

    private MetadataType visitDateTime(DefaultDateTimeType dateTimeType) {
        return this.transformDateTime(dateTimeType.getMetadataFormat(), this.getExtensions((BaseMetadataType)dateTimeType));
    }

    protected MetadataType transformDateTime(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultDateTimeType(metadataFormat, extensions);
    }

    private MetadataType visitDate(DefaultDateType dateType) {
        return this.transformDateType(dateType.getMetadataFormat(), this.getExtensions((BaseMetadataType)dateType));
    }

    protected MetadataType transformDateType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultDateType(metadataFormat, extensions);
    }

    private MetadataType visitNull(DefaultNullType nullType) {
        return this.transformNullType(nullType.getMetadataFormat(), this.getExtensions((BaseMetadataType)nullType));
    }

    protected MetadataType transformNullType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultNullType(metadataFormat, extensions);
    }

    private MetadataType visitVoid(DefaultVoidType voidType) {
        return this.transformVoidType(voidType.getMetadataFormat(), this.getExtensions((BaseMetadataType)voidType));
    }

    protected MetadataType transformVoidType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultVoidType(metadataFormat, extensions);
    }

    private MetadataType visitNumber(DefaultNumberType numberType) {
        return this.transformNumberType(numberType.getMetadataFormat(), this.getExtensions((BaseMetadataType)numberType));
    }

    protected MetadataType transformNumberType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultNumberType(metadataFormat, extensions);
    }

    private MetadataType visitObject(DefaultObjectType objectType) {
        Supplier<List<ObjectFieldType>> fields = () -> objectType.getFields().stream().map(objectFieldType -> (ObjectFieldType)this.transform((MetadataType)objectFieldType)).collect(Collectors.toList());
        return this.transformObjectType(fields, objectType.isOrdered(), objectType.getOpenRestriction().map(this::transform).orElse(null), objectType.getMetadataFormat(), this.getExtensions((BaseMetadataType)objectType));
    }

    protected MetadataType transformObjectType(Supplier<List<ObjectFieldType>> fields, boolean ordered, MetadataType openRestriction, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultObjectType((Collection)fields.get(), ordered, openRestriction, metadataFormat, extensions);
    }

    private MetadataType visitString(DefaultStringType stringType) {
        return this.transformStringType(stringType.getMetadataFormat(), this.getExtensions((BaseMetadataType)stringType));
    }

    protected MetadataType transformStringType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultStringType(metadataFormat, extensions);
    }

    private MetadataType visitTime(DefaultTimeType timeType) {
        return this.transformTimeType(timeType.getMetadataFormat(), this.getExtensions((BaseMetadataType)timeType));
    }

    protected MetadataType transformTimeType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultTimeType(metadataFormat, extensions);
    }

    private MetadataType visitTuple(DefaultTupleType tupleType) {
        Supplier<List<MetadataType>> types = () -> tupleType.getTypes().stream().map(this::transform).collect(Collectors.toList());
        return this.transformTupleType(types, tupleType.getMetadataFormat(), this.getExtensions((BaseMetadataType)tupleType));
    }

    protected MetadataType transformTupleType(Supplier<List<MetadataType>> types, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultTupleType(types.get(), metadataFormat, extensions);
    }

    private MetadataType visitUnion(DefaultUnionType unionType) {
        Supplier<List<MetadataType>> types = () -> unionType.getTypes().stream().map(this::transform).collect(Collectors.toList());
        return this.transformUnionType(types, unionType.getMetadataFormat(), this.getExtensions((BaseMetadataType)unionType));
    }

    protected MetadataType transformUnionType(Supplier<List<MetadataType>> types, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultUnionType(types.get(), metadataFormat, extensions);
    }

    private MetadataType visitIntersection(DefaultIntersectionType intersectionType) {
        Supplier<List<MetadataType>> types = () -> intersectionType.getTypes().stream().map(this::transform).collect(Collectors.toList());
        return this.transformIntersectionType(types, intersectionType.getMetadataFormat(), this.getExtensions((BaseMetadataType)intersectionType));
    }

    protected MetadataType transformIntersectionType(Supplier<List<MetadataType>> types, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultIntersectionType(types.get(), metadataFormat, extensions);
    }

    private MetadataType visitObjectKey(DefaultObjectKeyType objectKeyType) {
        Supplier<List<AttributeFieldType>> attributes = () -> objectKeyType.getAttributes().stream().map(attributeFieldType -> (AttributeFieldType)this.transform((MetadataType)attributeFieldType)).collect(Collectors.toList());
        Optional<QName> name = Optional.ofNullable(objectKeyType.isName() ? objectKeyType.getName() : null);
        Optional<Pattern> pattern = Optional.ofNullable(objectKeyType.isPattern() ? objectKeyType.getPattern() : null);
        return this.transformObjectKeyType(name, pattern, attributes, objectKeyType.getMetadataFormat(), this.getExtensions((BaseMetadataType)objectKeyType));
    }

    protected MetadataType transformObjectKeyType(Optional<QName> name, Optional<Pattern> pattern, Supplier<List<AttributeFieldType>> attributes, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultObjectKeyType(name, pattern, (Collection)attributes.get(), metadataFormat, extensions);
    }

    private MetadataType visitAttributeKey(DefaultAttributeKeyType attributeKeyType) {
        Optional<QName> name = Optional.ofNullable(attributeKeyType.isName() ? attributeKeyType.getName() : null);
        Optional<Pattern> pattern = Optional.ofNullable(attributeKeyType.isPattern() ? attributeKeyType.getPattern() : null);
        return this.transformAttributeKeyType(name, pattern, attributeKeyType.getMetadataFormat(), this.getExtensions((BaseMetadataType)attributeKeyType));
    }

    protected MetadataType transformAttributeKeyType(Optional<QName> name, Optional<Pattern> pattern, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultAttributeKeyType(name, pattern, metadataFormat, extensions);
    }

    private MetadataType visitAttributeField(DefaultAttributeFieldType attributeFieldType) {
        return this.transformAttributeFieldType(() -> (AttributeKeyType)this.transform((MetadataType)attributeFieldType.getKey()), () -> (SimpleType)this.transform((MetadataType)attributeFieldType.getValue()), attributeFieldType.isRequired(), attributeFieldType.getMetadataFormat(), this.getExtensions((BaseMetadataType)attributeFieldType));
    }

    protected MetadataType transformAttributeFieldType(Supplier<AttributeKeyType> key, Supplier<SimpleType> value, boolean required, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultAttributeFieldType(key.get(), value.get(), required, metadataFormat, extensions);
    }

    private MetadataType visitObjectField(DefaultObjectFieldType objectFieldType) {
        return this.transformDefaultObjectFieldType(() -> (ObjectKeyType)this.transform((MetadataType)objectFieldType.getKey()), () -> this.transform(objectFieldType.getValue()), objectFieldType.isRequired(), objectFieldType.isRepeated(), objectFieldType.getMetadataFormat(), this.getExtensions((BaseMetadataType)objectFieldType));
    }

    protected MetadataType transformDefaultObjectFieldType(Supplier<ObjectKeyType> key, Supplier<MetadataType> value, boolean required, boolean repeated, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultObjectFieldType(key.get(), value.get(), required, repeated, metadataFormat, extensions);
    }

    private MetadataType visitNothing(DefaultNothingType nothingType) {
        return this.transformNothingType(nothingType.getMetadataFormat(), this.getExtensions((BaseMetadataType)nothingType));
    }

    protected MetadataType transformNothingType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultNothingType(metadataFormat, extensions);
    }

    private MetadataType visitFunction(DefaultFunctionType functionType) {
        Supplier<List<FunctionParameter>> functionParameters = () -> functionType.getParameters().stream().map(functionParameter -> new FunctionParameter(functionParameter.getName(), this.transform(functionParameter.getType()))).collect(Collectors.toList());
        Supplier<Optional<MetadataType>> returnType = () -> functionType.getReturnType().map(this::transform);
        return this.transformFunctionType(functionType.getMetadataFormat(), this.getExtensions((BaseMetadataType)functionType), returnType, functionParameters);
    }

    protected MetadataType transformFunctionType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions, Supplier<Optional<MetadataType>> returnType, Supplier<List<FunctionParameter>> functionParameters) {
        return new DefaultFunctionType(metadataFormat, extensions, returnType.get(), functionParameters.get());
    }

    private MetadataType visitLocalDateTime(DefaultLocalDateTimeType localDateTimeType) {
        return this.transformLocalDateTimeType(localDateTimeType.getMetadataFormat(), this.getExtensions((BaseMetadataType)localDateTimeType));
    }

    protected MetadataType transformLocalDateTimeType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultLocalDateTimeType(metadataFormat, extensions);
    }

    private MetadataType visitLocalTime(DefaultLocalTimeType localTimeType) {
        return this.transformLocalTimeType(localTimeType.getMetadataFormat(), this.getExtensions((BaseMetadataType)localTimeType));
    }

    protected MetadataType transformLocalTimeType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultLocalTimeType(metadataFormat, extensions);
    }

    private MetadataType visitPeriod(DefaultPeriodType periodType) {
        return this.transformDefaultPeriodType(periodType.getMetadataFormat(), this.getExtensions((BaseMetadataType)periodType));
    }

    protected MetadataType transformDefaultPeriodType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultPeriodType(metadataFormat, extensions);
    }

    private MetadataType visitRegex(DefaultRegexType regexType) {
        return this.transformDefaultRegexType(regexType.getMetadataFormat(), this.getExtensions((BaseMetadataType)regexType));
    }

    protected MetadataType transformDefaultRegexType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultRegexType(metadataFormat, extensions);
    }

    private MetadataType visitTimeZone(DefaultTimeZoneType timeZoneType) {
        return this.transformDefaultTimeZoneType(timeZoneType.getMetadataFormat(), this.getExtensions((BaseMetadataType)timeZoneType));
    }

    protected MetadataType transformDefaultTimeZoneType(MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultTimeZoneType(metadataFormat, extensions);
    }

    private MetadataType visitTypeParameter(DefaultTypeParameterType defaultTypeParameter) {
        return this.transformDefaultTypeParameterType(defaultTypeParameter.getName(), defaultTypeParameter.getMetadataFormat(), this.getExtensions((BaseMetadataType)defaultTypeParameter));
    }

    protected MetadataType transformDefaultTypeParameterType(String name, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultTypeParameterType(name, metadataFormat, extensions);
    }
}

