/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.tooling;

import java.util.Optional;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.HasDynamicMetadataAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.OperationModelMetadataKeyEnricher;
import org.mule.datasense.impl.model.annotations.SourceModelMetadataKeyEnricher;
import org.mule.datasense.impl.model.annotations.metadata.OperationModelAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.SourceModelAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.tooling.MetadataQueryResult;
import org.mule.datasense.impl.tooling.TypedApplicationQuery;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.config.spring.dsl.model.DslElementModel;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;

public class MetadataQuery
implements TypedApplicationQuery<MetadataQueryResult> {
    private final Location location;
    private final OperationModelMetadataKeyEnricher operationModelMetadataKeyEnricher;
    private final SourceModelMetadataKeyEnricher sourceModelMetadataKeyEnricher;

    public MetadataQuery(Location location) {
        this.location = location;
        this.operationModelMetadataKeyEnricher = new OperationModelMetadataKeyEnricher();
        this.sourceModelMetadataKeyEnricher = new SourceModelMetadataKeyEnricher();
    }

    private OperationModel enrichOperationModel(MessageProcessorNode messageProcessorNode, OperationModel operationModel, DataSenseProviderResolver dataSenseProviderResolver, AstNotification astNotification) {
        return dataSenseProviderResolver.getDataSenseProvider().getDataSenseMetadataProvider().map(dataSenseMetadataProvider -> {
            Optional dslElementModelOptional;
            ComponentConfiguration componentConfiguration;
            OperationModel result = operationModel;
            if (messageProcessorNode.isAnnotatedWith(HasDynamicMetadataAnnotation.class) && DataSenseProviderResolver.isDynamicDataSenseSupportedFor(messageProcessorNode) && (componentConfiguration = messageProcessorNode.getComponentModel().getConfiguration()) != null && (dslElementModelOptional = dataSenseProviderResolver.getDslElementModelFactory().create(componentConfiguration)).isPresent()) {
                DslElementModel dslElementModel = (DslElementModel)dslElementModelOptional.get();
                OperationCall operationCall = messageProcessorNode.getAnnotation(OperationCallAnnotation.class).map(OperationCallAnnotation::getOperationCall).orElse(null);
                result = this.operationModelMetadataKeyEnricher.enrich(operationModel, dslElementModel, operationCall, this.location, (DataSenseMetadataProvider)dataSenseMetadataProvider, astNotification);
            }
            return result;
        }).orElse(operationModel);
    }

    private SourceModel enrichSourceModel(MessageProcessorNode messageProcessorNode, SourceModel sourceModel, DataSenseProviderResolver dataSenseProviderResolver, AstNotification astNotification) {
        return dataSenseProviderResolver.getDataSenseProvider().getDataSenseMetadataProvider().map(dataSenseMetadataProvider -> {
            Optional dslElementModelOptional;
            ComponentConfiguration componentConfiguration;
            SourceModel result = sourceModel;
            if (messageProcessorNode.isAnnotatedWith(HasDynamicMetadataAnnotation.class) && DataSenseProviderResolver.isDynamicDataSenseSupportedFor(messageProcessorNode) && (componentConfiguration = messageProcessorNode.getComponentModel().getConfiguration()) != null && (dslElementModelOptional = dataSenseProviderResolver.getDslElementModelFactory().create(componentConfiguration)).isPresent()) {
                DslElementModel dslElementModel = (DslElementModel)dslElementModelOptional.get();
                OperationCall operationCall = messageProcessorNode.getAnnotation(OperationCallAnnotation.class).map(OperationCallAnnotation::getOperationCall).orElse(null);
                result = this.sourceModelMetadataKeyEnricher.enrich(sourceModel, dslElementModel, operationCall, this.location, (DataSenseMetadataProvider)dataSenseMetadataProvider, astNotification);
            }
            return result;
        }).orElse(sourceModel);
    }

    @Override
    public Optional<MetadataQueryResult> perform(MuleApplicationNode muleApplicationNode, DataSenseProviderResolver dataSenseProviderResolver, AstNotification astNotification) {
        return muleApplicationNode.findMessageProcessorNode(this.location).map(messageProcessorNode -> new MetadataQueryResult(messageProcessorNode.getAnnotation(OperationModelAnnotation.class).map(operationModelAnnotation -> this.enrichOperationModel((MessageProcessorNode)messageProcessorNode, operationModelAnnotation.getOperationModel(), dataSenseProviderResolver, astNotification)).orElse(null), messageProcessorNode.getAnnotation(SourceModelAnnotation.class).map(sourceModelAnnotation -> this.enrichSourceModel((MessageProcessorNode)messageProcessorNode, sourceModelAnnotation.getSourceModel(), dataSenseProviderResolver, astNotification)).orElse(null)));
    }
}

