/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.annotations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.LocationUtils;
import org.mule.datasense.impl.util.LogSupport;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.message.MessageMetadataType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.spring.api.dsl.model.DslElementModel;
import org.mule.runtime.extension.internal.property.MetadataKeyPartModelProperty;

public abstract class ComponentModelMetadataKeyEnricher<T>
implements LogSupport {
    protected String getPartName(Set<MetadataKey> metadataKeys) {
        if (metadataKeys == null) {
            return null;
        }
        return metadataKeys.stream().findFirst().map(MetadataKey::getPartName).orElse(null);
    }

    protected String[] enumOfKeyValues(Set<MetadataKey> metadataKeys) {
        List<String> collect = metadataKeys.stream().map(MetadataKey::getId).collect(Collectors.toList());
        return collect.toArray(new String[collect.size()]);
    }

    protected Optional<String> findKeyPartConfiguredValue(DslElementModel<T> componentModelDslElementModel, String keyPartName) {
        return componentModelDslElementModel.getConfiguration().map(componentConfiguration -> (String)componentConfiguration.getParameters().get(keyPartName));
    }

    protected void filterMetadataKeys(Map<String, Set<MetadataKey>> metadataKeysByPart, Set<MetadataKey> metadataKeys, DslElementModel<T> componentModelDslElementModel) {
        Optional<String> optionalKeyPart = metadataKeys.stream().findFirst().map(MetadataKey::getPartName);
        if (!optionalKeyPart.isPresent()) {
            return;
        }
        String keyPart = optionalKeyPart.get();
        metadataKeysByPart.put(keyPart, metadataKeys);
        Optional<String> optionalKeyPartConfiguredValue = this.findKeyPartConfiguredValue(componentModelDslElementModel, keyPart);
        if (!optionalKeyPartConfiguredValue.isPresent()) {
            return;
        }
        String KeyPartConfiguredValue = optionalKeyPartConfiguredValue.get();
        Optional<MetadataKey> matchingKey = metadataKeys.stream().filter(metadataKey1 -> metadataKey1.getId().equals(KeyPartConfiguredValue)).findFirst();
        if (!matchingKey.isPresent()) {
            metadataKeysByPart.put(keyPart, metadataKeys);
            return;
        }
        this.filterMetadataKeys(metadataKeysByPart, matchingKey.get().getChilds(), componentModelDslElementModel);
    }

    protected Function<ParameterModel, MetadataType> getParameterModelMetadataTypeFunction(Map<String, Set<MetadataKey>> metadataKeysByPart, OperationCall operationCall) {
        HashMap operationCallParameters = new HashMap();
        if (operationCall != null) {
            operationCall.getInputMappings().forEach(inputMapping -> {
                String name = inputMapping.getInputParameter().getName();
                MetadataType metadataType = inputMapping.getInputParameter().getMetadataType();
                if (name != null && metadataType != null) {
                    operationCallParameters.put(name, metadataType);
                }
            });
        }
        return parameterModel -> {
            Optional metadataKeys = Optional.ofNullable(metadataKeysByPart.get(parameterModel.getName()));
            if (metadataKeys.isPresent() && parameterModel.getType() instanceof StringType) {
                StringTypeBuilder typeBuilder = TypesHelper.getTypeBuilder(MetadataFormat.JAVA).stringType();
                Set annotations = parameterModel.getType().getAnnotations();
                HashSet<EnumAnnotation> newAnnotations = new HashSet<EnumAnnotation>();
                annotations.stream().filter(typeAnnotation -> !(typeAnnotation instanceof EnumAnnotation)).forEach(newAnnotations::add);
                newAnnotations.add(new EnumAnnotation((Object[])this.enumOfKeyValues((Set)metadataKeys.get())));
                newAnnotations.forEach(arg_0 -> ((StringTypeBuilder)typeBuilder).with(arg_0));
                return typeBuilder.build();
            }
            if (operationCallParameters.containsKey(parameterModel.getName())) {
                return (MetadataType)operationCallParameters.get(parameterModel.getName());
            }
            return parameterModel.getType();
        };
    }

    private Optional<MessageMetadataType> returnTypeAsMessageMetadatatype(OperationCall operationCall) {
        if (operationCall == null) {
            return Optional.empty();
        }
        MetadataType metadataType = operationCall.getReturnType();
        return Optional.ofNullable(metadataType instanceof MessageMetadataType ? (MessageMetadataType)metadataType : null);
    }

    protected Function<OutputModel, MetadataType> getOutputMetadataTypeFunction(OperationCall operationCall) {
        return outputModel -> this.returnTypeAsMessageMetadatatype(operationCall).flatMap(MessageMetadataType::getPayloadType).orElse(outputModel.getType());
    }

    protected Function<OutputModel, MetadataType> getOutputAttributesMetadataTypeFunction(OperationCall operationCall) {
        return outputModel -> this.returnTypeAsMessageMetadatatype(operationCall).flatMap(MessageMetadataType::getAttributesType).orElse(outputModel.getType());
    }

    public T enrich(T model, DslElementModel<T> componentModelDslElementModel, OperationCall operationCall, Location location, DataSenseMetadataProvider dataSenseMetadataProvider, AstNotification astNotification) {
        HashMap<String, Set<MetadataKey>> metadataKeysByPart = new HashMap<String, Set<MetadataKey>>();
        if (this.hasKeyParameter(componentModelDslElementModel)) {
            MetadataResult<MetadataKeysContainer> metadataResult = dataSenseMetadataProvider.getMetadataKeys(location);
            if (metadataResult != null) {
                if (metadataResult.isSuccess()) {
                    MetadataKeysContainer metadataKeysContainer = (MetadataKeysContainer)metadataResult.get();
                    metadataKeysContainer.getKeysByCategory().values().stream().findFirst().ifPresent(metadataKeys -> this.filterMetadataKeys((Map<String, Set<MetadataKey>>)metadataKeysByPart, (Set<MetadataKey>)metadataKeys, componentModelDslElementModel));
                } else {
                    metadataResult.getFailures().forEach(metadataFailure -> astNotification.reportError(new AstNodeLocation(LocationUtils.asComponentLocation(null, location)), NotificationMessages.MSG_FAILED_TO_ENRICH_KEYS(metadataFailure), metadataFailure.getFailureCode(), metadataFailure.getFailingComponent(), metadataFailure.getFailingElement().orElse(null), NotificationMessages.REASON_FAILED_TO_ENRICH_KEYS(metadataFailure)));
                }
            } else {
                astNotification.reportError(new AstNodeLocation(LocationUtils.asComponentLocation(null, location)), I18nMessageFactory.createStaticMessage((String)"Failed to obtain dynamic metadata resolving request [%s].", (Object[])new Object[]{"metadatakeys for component_path: " + location}));
            }
        }
        T result = this.enrich(model, metadataKeysByPart, operationCall);
        return result;
    }

    private boolean hasKeyParameter(DslElementModel<T> componentModelDslElementModel) {
        if (componentModelDslElementModel.getModel() instanceof ComponentModel) {
            List parameterModels = ((ComponentModel)componentModelDslElementModel.getModel()).getAllParameterModels();
            for (ParameterModel parameterModel : parameterModels) {
                if (!parameterModel.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract T enrich(T var1, Map<String, Set<MetadataKey>> var2, OperationCall var3);
}

