/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.BaseAstNode;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class MessageProcessorNode
extends BaseAstNode {
    private final ComponentModelType componentModelType;
    private final ComponentIdentifier componentIdentifier;
    private final ComponentModel componentModel;
    private final List<MessageProcessorNode> messageProcessorNodeList;
    private AstNode parentAstNode;
    private boolean rootMessageProcessorNode;
    private boolean synthetic;

    public MessageProcessorNode(ComponentIdentifier componentIdentifier, ComponentModel componentModel, List<MessageProcessorNode> messageProcessorNodeList, FunctionType declaredFunctionType, ComponentModelType componentModelType) {
        this(componentIdentifier, componentModel, messageProcessorNodeList, declaredFunctionType, componentModelType, false);
    }

    public MessageProcessorNode(ComponentIdentifier componentIdentifier, ComponentModel componentModel, List<MessageProcessorNode> messageProcessorNodeList, FunctionType declaredFunctionType, ComponentModelType componentModelType, boolean synthetic) {
        super(componentIdentifier);
        DefaultComponentLocation componentLocation;
        Preconditions.checkNotNull((Object)componentIdentifier);
        Preconditions.checkNotNull(messageProcessorNodeList);
        this.setName(componentIdentifier.toString());
        this.synthetic = synthetic;
        this.componentIdentifier = componentIdentifier;
        this.componentModel = componentModel;
        this.messageProcessorNodeList = messageProcessorNodeList;
        this.componentModelType = componentModelType;
        if (componentModel != null && (componentLocation = componentModel.getComponentLocation()) != null) {
            this.setAstNodeLocation(new AstNodeLocation((ComponentLocation)componentLocation));
        }
    }

    public MessageProcessorNode(ComponentIdentifier componentIdentifier, ComponentModel componentModel, List<MessageProcessorNode> messageProcessorNodeList, boolean synthetic) {
        this(componentIdentifier, componentModel, messageProcessorNodeList, null, null, synthetic);
    }

    public MessageProcessorNode(ComponentIdentifier componentIdentifier, ComponentModel componentModel, List<MessageProcessorNode> messageProcessorNodeList) {
        this(componentIdentifier, componentModel, messageProcessorNodeList, null, null, false);
    }

    public void setParentAstNode(AstNode parentAstNode) {
        this.parentAstNode = parentAstNode;
    }

    public AstNode getParentAstNode() {
        return this.parentAstNode;
    }

    public boolean isRootMessageProcessorNode() {
        return this.rootMessageProcessorNode;
    }

    public void setRootMessageProcessorNode(boolean rootMessageProcessorNode) {
        this.rootMessageProcessorNode = rootMessageProcessorNode;
    }

    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public Stream<MessageProcessorNode> getMessageProcessorNodes() {
        return this.messageProcessorNodeList.stream();
    }

    @Override
    public <T> Object accept(AstNodeVisitor<T> astNodeVisitor, T context) {
        return astNodeVisitor.visit(this, context);
    }

    public ComponentModel getComponentModel() {
        return this.componentModel;
    }

    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.ofNullable(this.componentModelType);
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }
}

