/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.MetadataTypeSubstitution;
import org.mule.datasense.impl.model.types.MetadataTypeUnification;
import org.mule.datasense.impl.model.types.TypeEquivalence;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.message.MessageMetadataType;
import org.mule.metadata.message.MessageMetadataTypeBuilder;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.message.Message;

public class TypeUtils {
    public static boolean isAssignable(MetadataType sourceType, MetadataType targetType) {
        return TypeEquivalence.canBeAssignedTo(sourceType, targetType, null);
    }

    public static Stream<VarDecl> asVarDecls(MessageMetadataType messageMetadataType, boolean includeVoids) {
        HashSet varDecls = new HashSet();
        messageMetadataType.getPayloadType().filter(metadataType -> includeVoids || !(metadataType instanceof VoidType)).ifPresent(metadataType -> varDecls.add(new VarDecl("#payload#", (MetadataType)metadataType)));
        messageMetadataType.getAttributesType().filter(metadataType -> includeVoids || !(metadataType instanceof VoidType)).ifPresent(metadataType -> varDecls.add(new VarDecl("#attributes#", (MetadataType)metadataType)));
        return varDecls.stream();
    }

    public static Stream<VarDecl> asVarDecls(MessageMetadataType messageMetadataType) {
        return TypeUtils.asVarDecls(messageMetadataType, true);
    }

    public static Stream<VarDecl> asVarDecls(MuleEventMetadataType muleEventMetadataType) {
        HashSet varDecls = new HashSet();
        if (muleEventMetadataType != null) {
            varDecls.addAll(TypeUtils.asVarDecls(muleEventMetadataType.getMessageType()).collect(Collectors.toList()));
            muleEventMetadataType.getVariables().getFields().forEach(objectFieldType -> varDecls.add(new VarDecl(objectFieldType.getKey().getName().getLocalPart(), objectFieldType.getValue())));
        }
        return varDecls.stream();
    }

    public static MuleEventMetadataTypeBuilder asMuleEventMetadataType(EventType eventType) {
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = MuleEventMetadataType.builder();
        if (eventType.getVarDecls() != null) {
            eventType.getVarDecls().forEach(dataDeclaration -> {
                MetadataType metadataType = dataDeclaration.getType();
                if (dataDeclaration.getName().equals("#payload#")) {
                    muleEventMetadataTypeBuilder.message().payload(dataDeclaration.getType());
                } else if (dataDeclaration.getName().equals("#attributes#")) {
                    muleEventMetadataTypeBuilder.message().attributes(dataDeclaration.getType());
                } else {
                    muleEventMetadataTypeBuilder.addVariable(dataDeclaration.getName(), metadataType);
                }
            });
        }
        return muleEventMetadataTypeBuilder;
    }

    public static EventType asEventType(MuleEventMetadataType muleEventMetadataType) {
        return new EventType(TypeUtils.asVarDecls(muleEventMetadataType));
    }

    public static EventType merge(EventType eventType1, EventType eventType2) {
        if (eventType1 == null) {
            return eventType2;
        }
        if (eventType2 == null) {
            return eventType1;
        }
        Set collect = eventType2.getVarDecls().collect(Collectors.toSet());
        collect.addAll(eventType1.getVarDecls().collect(Collectors.toSet()));
        return new EventType(collect.stream());
    }

    public static EventType minus(EventType eventType1, EventType eventType2) {
        if (eventType1 == null) {
            return null;
        }
        if (eventType2 == null) {
            return eventType1;
        }
        return new EventType(eventType1.getVarDecls().filter(varDecl -> !eventType2.get(varDecl.getName()).isPresent()));
    }

    public static MetadataType override(MetadataType metadataType1, MetadataType metadataType2) {
        MetadataType result;
        if (metadataType1 == null) {
            return metadataType2;
        }
        if (metadataType2 == null) {
            return metadataType1;
        }
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
        if (metadataType1 instanceof MessageMetadataType) {
            MessageMetadataType messageMetadataType1 = (MessageMetadataType)metadataType1;
            if (metadataType2 instanceof MessageMetadataType) {
                MetadataType attributesMetadataType;
                MessageMetadataType messageMetadataType2 = (MessageMetadataType)metadataType2;
                MetadataType payloadMetadataType = messageMetadataType2.getPayloadType().orElse(messageMetadataType1.getPayloadType().orElse(null));
                if (payloadMetadataType != null) {
                    messageMetadataTypeBuilder.payload(payloadMetadataType);
                }
                if ((attributesMetadataType = (MetadataType)messageMetadataType2.getAttributesType().orElse(messageMetadataType1.getAttributesType().orElse(null))) != null) {
                    messageMetadataTypeBuilder.attributes(attributesMetadataType);
                }
            } else {
                messageMetadataTypeBuilder.payload(metadataType2);
                messageMetadataType1.getAttributesType().ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)messageMetadataTypeBuilder).attributes(arg_0));
            }
            result = messageMetadataTypeBuilder.build();
        } else {
            result = metadataType2;
        }
        return result;
    }

    public static Optional<Map<String, MetadataType>> unifyTypes(MetadataType metadataType1, MetadataType metadataType2) {
        MetadataTypeUnification metadataTypeUnification = new MetadataTypeUnification();
        return metadataTypeUnification.unify(metadataType1, metadataType2);
    }

    public static MetadataType substitute(MetadataType metadataType, Map<String, MetadataType> substitution) {
        if (substitution == null || substitution.isEmpty()) {
            return metadataType;
        }
        MetadataTypeSubstitution metadataTypeSubstitution = new MetadataTypeSubstitution(substitution);
        return metadataTypeSubstitution.transform(metadataType);
    }

    public static EventType union(List<EventType> eventTypes) {
        if (eventTypes == null || eventTypes.size() == 0) {
            return new EventType();
        }
        HashMap metadataTypesByVar = new HashMap();
        eventTypes.forEach(eventType -> eventType.getVarDecls().forEach(varDecl -> {
            LinkedHashSet<MetadataType> metadataTypes = (LinkedHashSet<MetadataType>)metadataTypesByVar.get(varDecl.getName());
            if (metadataTypes == null) {
                metadataTypes = new LinkedHashSet<MetadataType>();
                metadataTypesByVar.put(varDecl.getName(), metadataTypes);
            }
            metadataTypes.add(varDecl.getType());
        }));
        ArrayList varDecls = new ArrayList();
        metadataTypesByVar.entrySet().forEach(stringListEntry -> {
            String varName = (String)stringListEntry.getKey();
            Set typeList = (Set)stringListEntry.getValue();
            if (typeList.size() > 0) {
                VarDecl varDecl = null;
                if (typeList.size() == 1) {
                    varDecl = new VarDecl(varName, (MetadataType)typeList.iterator().next());
                } else {
                    UnionTypeBuilder unionTypeBuilder = TypesHelper.getTypeBuilder().unionType();
                    typeList.forEach(arg_0 -> ((UnionTypeBuilder)unionTypeBuilder).of(arg_0));
                    varDecl = new VarDecl(varName, (MetadataType)unionTypeBuilder.build());
                }
                varDecls.add(varDecl);
            }
        });
        return new EventType(varDecls.stream());
    }

    public static EventType intersection(List<EventType> eventTypes) {
        if (eventTypes == null || eventTypes.size() == 0) {
            return new EventType();
        }
        HashMap metadataTypesByVar = new HashMap();
        eventTypes.forEach(eventType -> eventType.getVarDecls().forEach(varDecl -> {
            LinkedHashSet<MetadataType> metadataTypes = (LinkedHashSet<MetadataType>)metadataTypesByVar.get(varDecl.getName());
            if (metadataTypes == null) {
                metadataTypes = new LinkedHashSet<MetadataType>();
                metadataTypesByVar.put(varDecl.getName(), metadataTypes);
            }
            metadataTypes.add(varDecl.getType());
        }));
        ArrayList varDecls = new ArrayList();
        metadataTypesByVar.entrySet().forEach(stringListEntry -> {
            String varName = (String)stringListEntry.getKey();
            Set typeList = (Set)stringListEntry.getValue();
            if (typeList.size() > 0) {
                VarDecl varDecl = null;
                varDecl = typeList.size() == 1 ? new VarDecl(varName, (MetadataType)typeList.iterator().next()) : new VarDecl(varName, (MetadataType)TypesHelper.getTypeBuilder().anyType().build());
                varDecls.add(varDecl);
            }
        });
        return new EventType(varDecls.stream());
    }

    public static EventType override(EventType eventType1, EventType eventType2) {
        if (eventType1 == null) {
            return eventType2;
        }
        if (eventType2 == null) {
            return eventType1;
        }
        HashMap varDecls = new HashMap();
        eventType1.getVarDecls().forEach(varDecl -> varDecls.put(varDecl.getName(), varDecl));
        eventType2.getVarDecls().forEach(varDecl -> {
            VarDecl overridenVarDecl = (VarDecl)varDecls.get(varDecl.getName());
            if (overridenVarDecl != null) {
                varDecls.put(overridenVarDecl.getName(), new VarDecl(overridenVarDecl.getName(), TypeUtils.override(overridenVarDecl.getType(), varDecl.getType())));
            } else {
                varDecls.put(varDecl.getName(), varDecl);
            }
        });
        return new EventType(varDecls.values().stream());
    }

    public static EventType createEventType(MetadataType metadataType) {
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        if (metadataType != null) {
            muleEventMetadataTypeBuilder.message().payload(metadataType);
        }
        MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
        return TypeUtils.asEventType(muleEventMetadataType);
    }

    public static Optional<MetadataType> getMessagePayloadType(MetadataType metadataType) {
        if (metadataType == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metadataType instanceof MessageMetadataType ? (MetadataType)((MessageMetadataType)metadataType).getPayloadType().orElse(null) : null);
    }

    public static Optional<MetadataType> getMessageAttributesType(MetadataType metadataType) {
        if (metadataType == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metadataType instanceof MessageMetadataType ? (MetadataType)((MessageMetadataType)metadataType).getAttributesType().orElse(null) : null);
    }

    public static Optional<MessageMetadataType> getMessageMetadataType(EventType eventType) {
        if (eventType == null) {
            return Optional.empty();
        }
        VarDecl messagePayload = eventType.get("#payload#").orElse(null);
        VarDecl messageAttributes = eventType.get("#attributes#").orElse(null);
        if (messagePayload != null || messageAttributes != null) {
            MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
            eventType.get("#payload#").ifPresent(varDecl -> messageMetadataTypeBuilder.payload(varDecl.getType()));
            eventType.get("#attributes#").ifPresent(varDecl -> messageMetadataTypeBuilder.attributes(varDecl.getType()));
            return Optional.of(messageMetadataTypeBuilder.build());
        }
        return Optional.empty();
    }

    private static boolean isMessageMetadataType(MetadataType elementMetadataType) {
        return elementMetadataType.getAnnotation(TypeIdAnnotation.class).map(typeIdAnnotation -> Message.class.getName().equals(typeIdAnnotation.getValue())).orElse(false);
    }

    public static Optional<MessageMetadataType> asMessageMetadataType(MetadataType metadataType) {
        ObjectType objectType;
        Optional<MessageMetadataType> result = Optional.empty();
        if (metadataType instanceof ObjectType && TypeUtils.isMessageMetadataType((MetadataType)(objectType = (ObjectType)metadataType))) {
            MessageMetadataTypeBuilder messageMetadataTypeBuilder = new MessageMetadataTypeBuilder();
            objectType.getFieldByName("payload").ifPresent(objectFieldType -> messageMetadataTypeBuilder.payload(objectFieldType.getValue()));
            objectType.getFieldByName("attributes").ifPresent(objectFieldType -> messageMetadataTypeBuilder.attributes(objectFieldType.getValue()));
            result = Optional.of(messageMetadataTypeBuilder.build());
        }
        return result;
    }
}

