/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;

public class MessageProcessorNodeBuilder
implements AstNodeBuilder<MessageProcessorNode> {
    private final ComponentIdentifier componentIdentifier;
    private ComponentModelType componentModelType;
    private ComponentModel componentModel;
    private List<MessageProcessorNodeBuilder> messageProcessorNodeBuilderList;
    private FunctionType declaredFunctionType;
    private boolean rootMessageProcessorNode;
    private boolean synthetic;

    public MessageProcessorNodeBuilder(ComponentIdentifier componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
        this.componentModel = null;
        this.declaredFunctionType = null;
        this.componentModelType = null;
        this.messageProcessorNodeBuilderList = new ArrayList<MessageProcessorNodeBuilder>();
    }

    public MessageProcessorNodeBuilder(String componentIdentifier) {
        this(ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier));
    }

    public MessageProcessorNodeBuilder messageProcessor(MessageProcessorNodeBuilder messageProcessorNodeBuilder) {
        this.messageProcessorNodeBuilderList.add(messageProcessorNodeBuilder);
        return this;
    }

    public MessageProcessorNodeBuilder messageProcessor(String componentIdentifier, Consumer<MessageProcessorNodeBuilder> messageProcessorNodeBuilderConsumer) {
        return this.messageProcessor(ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier), messageProcessorNodeBuilderConsumer);
    }

    public MessageProcessorNodeBuilder messageProcessor(ComponentIdentifier componentIdentifier, Consumer<MessageProcessorNodeBuilder> messageProcessorNodeBuilderConsumer) {
        MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
        this.messageProcessorNodeBuilderList.add(messageProcessorNodeBuilder);
        if (messageProcessorNodeBuilderConsumer != null) {
            messageProcessorNodeBuilderConsumer.accept(messageProcessorNodeBuilder);
        }
        return this;
    }

    public MessageProcessorNodeBuilder messageProcessor(String componentIdentifier) {
        return this.messageProcessor(componentIdentifier, null);
    }

    public MessageProcessorNodeBuilder declaredFunctionType(FunctionType functionType) {
        this.declaredFunctionType = functionType;
        return this;
    }

    public MessageProcessorNodeBuilder config(ComponentModel componentModel) {
        this.componentModel = componentModel;
        return this;
    }

    public MessageProcessorNodeBuilder componentModelType(ComponentModelType componentModelType) {
        this.componentModelType = componentModelType;
        return this;
    }

    public MessageProcessorNodeBuilder root() {
        this.rootMessageProcessorNode = true;
        return this;
    }

    public MessageProcessorNodeBuilder synthetic() {
        this.synthetic = true;
        return this;
    }

    @Override
    public MessageProcessorNode build() {
        List<MessageProcessorNode> children = this.messageProcessorNodeBuilderList.stream().map(MessageProcessorNodeBuilder::build).collect(Collectors.toList());
        MessageProcessorNode messageProcessorNode = new MessageProcessorNode(this.componentIdentifier, this.componentModel, children, this.declaredFunctionType, this.componentModelType, this.synthetic);
        children.forEach(child -> child.setParentAstNode(messageProcessorNode));
        messageProcessorNode.setRootMessageProcessorNode(this.rootMessageProcessorNode);
        return messageProcessorNode;
    }
}

