/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitor;
import org.mule.datasense.impl.phases.scoping.ExpectedAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.PipedChainTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.MessageMetadataType;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.el.ExpressionLanguageMetadataTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;

public class ForEachTypeResolver
extends PipedChainTypeResolver {
    private static final String ATTR_BATCH_SIZE = "batchSize";
    private static final String ATTR_COLLECTION = "collection";
    private static final String ATTR_COUNTER_VARIABLE_NAME = "counterVariableName";
    private static final String ATTR_MESSAGE_VARIABLE_NAME = "rootMessageVariableName";
    private static final String DEFAULT_COUNTER_VARIABLE_NAME = "counter";
    private static final String DEFAULT_MESSAGE_VARIABLE_NAME = "rootMessage";
    private static final String DEFAULT_COLLECTION_EXPRESSION = "#[payload]";
    private static final int DEFAULT_BATCH_SIZE = 1;

    private static boolean isBatchMode(ComponentModel componentModel) {
        boolean result;
        String expression = (String)componentModel.getParameters().get(ATTR_BATCH_SIZE);
        if (expression == null) {
            result = false;
        } else if (ExpressionLanguageUtils.isExpression(expression)) {
            result = true;
        } else {
            try {
                result = Integer.parseInt(expression) > 1;
            }
            catch (NumberFormatException e) {
                result = false;
            }
        }
        return result;
    }

    private static Optional<MetadataType> buildInnerPayloadType(MetadataType metadataType) {
        if (metadataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)metadataType;
            return Optional.of(arrayType.getType());
        }
        if (metadataType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)metadataType;
            LinkedHashSet metadataTypes = new LinkedHashSet();
            objectType.getFields().forEach(objectFieldType -> metadataTypes.add(objectFieldType.getValue()));
            if (metadataTypes.size() == 0) {
                return Optional.empty();
            }
            if (metadataTypes.size() == 1) {
                return Optional.of(metadataTypes.iterator().next());
            }
            UnionTypeBuilder unionTypeBuilder = TypesHelper.getTypeBuilder().unionType();
            metadataTypes.forEach(arg_0 -> ((UnionTypeBuilder)unionTypeBuilder).of(arg_0));
            return Optional.of(unionTypeBuilder.build());
        }
        return Optional.empty();
    }

    private static EventType buildInnerEventType(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        ComponentModel componentModel = messageProcessorNode.getComponentModel();
        String collectionExpression = Optional.ofNullable(componentModel.getParameters().get(ATTR_COLLECTION)).orElse(DEFAULT_COLLECTION_EXPRESSION);
        boolean batchMode = ForEachTypeResolver.isBatchMode(componentModel);
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        Optional payloadMetadataTypeOptional = TypeUtils.getMessageMetadataType(inputEventType).flatMap(MessageMetadataType::getPayloadType);
        MetadataType elementMetadataType = (MetadataType)payloadMetadataTypeOptional.flatMap(payloadMetadataType -> {
            MetadataType sourceCollectionMetadataType = ExpressionLanguageUtils.extractExpression(collectionExpression).map(e -> ExpressionLanguageUtils.resolveExpressionType(e, inputEventType, typingMuleAstVisitorContext.getExpressionLanguageMetadataTypeResolver(), new ExpressionLanguageMetadataTypeResolver.MessageCallback(){

                public void warning(String s) {
                }

                public void error(String s) {
                }
            })).orElse(null);
            return ForEachTypeResolver.buildInnerPayloadType(sourceCollectionMetadataType);
        }).orElse(TypesHelper.getTypeBuilder().anyType().build());
        if (batchMode) {
            muleEventMetadataTypeBuilder.message().payload().arrayType().of(elementMetadataType);
        } else {
            Optional<MessageMetadataType> optionalElementMessageMetadataType = TypeUtils.asMessageMetadataType(elementMetadataType);
            if (optionalElementMessageMetadataType.isPresent()) {
                MessageMetadataType elementMessageMetadataType = optionalElementMessageMetadataType.get();
                elementMessageMetadataType.getPayloadType().ifPresent(metadataType -> muleEventMetadataTypeBuilder.message().payload(metadataType));
                elementMessageMetadataType.getAttributesType().ifPresent(metadataType -> muleEventMetadataTypeBuilder.message().attributes(metadataType));
            } else {
                muleEventMetadataTypeBuilder.message().payload(elementMetadataType);
            }
        }
        String counterVariableName = Optional.ofNullable(componentModel.getParameters().get(ATTR_COUNTER_VARIABLE_NAME)).orElse(DEFAULT_COUNTER_VARIABLE_NAME);
        muleEventMetadataTypeBuilder.addVariable(counterVariableName).numberType();
        String messageVariableName = Optional.ofNullable(componentModel.getParameters().get(ATTR_MESSAGE_VARIABLE_NAME)).orElse(DEFAULT_MESSAGE_VARIABLE_NAME);
        muleEventMetadataTypeBuilder.addVariable(messageVariableName, (MetadataType)payloadMetadataTypeOptional.orElse(TypesHelper.getTypeBuilder().anyType().build()));
        MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
        return TypeUtils.asEventType(muleEventMetadataType);
    }

    private EventType buildExpectedEventType(MessageProcessorNode messageProcessorNode, EventType innerEventType) {
        MetadataType payloadMetadataType;
        ComponentModel componentModel = messageProcessorNode.getComponentModel();
        String collectionExpression = Optional.ofNullable(componentModel.getParameters().get(ATTR_COLLECTION)).orElse(DEFAULT_COLLECTION_EXPRESSION);
        boolean batchMode = ForEachTypeResolver.isBatchMode(componentModel);
        MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
        if (collectionExpression.equals(DEFAULT_COLLECTION_EXPRESSION) && (payloadMetadataType = (MetadataType)TypeUtils.getMessageMetadataType(innerEventType).flatMap(MessageMetadataType::getPayloadType).orElse(null)) != null) {
            if (batchMode) {
                muleEventMetadataTypeBuilder.message().payload(payloadMetadataType);
            } else {
                muleEventMetadataTypeBuilder.message().payload((MetadataType)TypesHelper.getTypeBuilder().arrayType().of(payloadMetadataType).build());
            }
        }
        MuleEventMetadataType muleEventMetadataType = muleEventMetadataTypeBuilder.build();
        return TypeUtils.asEventType(muleEventMetadataType);
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        EventType innerEventType = inputEventType;
        List messageProcessorNodes = messageProcessorNode.getMessageProcessorNodes().collect(Collectors.toList());
        Optional<EventType> previousEventType = Optional.empty();
        for (MessageProcessorNode pipedMessageProcessorNode : messageProcessorNodes) {
            EventType pipedInputEvent = previousEventType.isPresent() ? previousEventType.map(eventType -> eventType).orElse(new EventType()) : innerEventType;
            EventType eventType2 = typingMuleAstVisitor.resolveType((AstNode)pipedMessageProcessorNode, pipedInputEvent, typingMuleAstVisitorContext);
            previousEventType = Optional.of(eventType2);
        }
        EventType outputEventType = inputEventType;
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(new EventType()));
        return outputEventType;
    }

    @Override
    protected EventType resolveExpectedInputEventType(EventType innerEventType, MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor, ExpectedAstVisitorContext visitorContext) {
        return this.buildExpectedEventType(messageProcessorNode, innerEventType);
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    @Override
    public Optional<MuleAstParseProvider> getParseProvider() {
        return Optional.of((componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders, muleAstParserContext) -> this.generateAst(componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders));
    }

    private Optional<AstNodeBuilder> generateAst(ComponentIdentifier componentIdentifier, ComponentModel componentModel, ComponentModelType componentModelType, List<MessageProcessorNodeBuilder> messageProcessorNodeBuilders) {
        MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
        messageProcessorNodeBuilder.config(componentModel);
        messageProcessorNodeBuilder.componentModelType(componentModelType);
        messageProcessorNodeBuilder.messageProcessor(DefaultDataSense.COMPONENT_IDENTIFIER_FOREACH_SCOPE_IN, m -> {
            m.config(componentModel);
            m.synthetic();
        });
        messageProcessorNodeBuilders.forEach(messageProcessorNodeBuilder::messageProcessor);
        return Optional.of(messageProcessorNodeBuilder);
    }

    @Override
    protected boolean isScope() {
        return true;
    }

    public static class ForEachScopeIn
    extends SingleNodeTypeResolver {
        @Override
        protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
            EventType scopeEventType = ForEachTypeResolver.buildInnerEventType(messageProcessorNode, inputEventType, visitorContext);
            messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
            messageProcessorNode.annotate(new DefinesTypeAnnotation(scopeEventType));
            return inputEventType;
        }

        @Override
        public EventType generateExpected(MessageProcessorNode messageProcessorNode, ExpectedAstVisitor expectedAstVisitor, ExpectedAstVisitorContext visitorContext) {
            return visitorContext.getExpectedEventType();
        }

        @Override
        protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
            return true;
        }
    }
}

