/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.api;

import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.runtime.api.component.location.Location;

import java.util.Optional;

public interface DataSense {

  Optional<DataSenseInfo> resolve(Location location, ApplicationModel applicationModel,
                                  DataSenseProvider dataSenseProvider);

  Optional<DataSenseInfo> resolve(DataSenseResolutionScope dataSenseResolutionScope, ApplicationModel applicationModel,
                                  DataSenseProvider dataSenseProvider);

  Optional<DataSenseComponentInfo> resolveComponent(Location location, ApplicationModel applicationModel,
                                                    DataSenseProvider dataSenseProvider);

  AnalysisResult analyze(DataSenseProvider dataSenseProvider, ApplicationModel applicationModel);
}
