package org.mule.datasense.api.metadataprovider;

import org.mule.runtime.api.exception.MuleRuntimeException;

import java.util.Optional;

public class ApplicationModelFromMuleConfigData extends BaseApplicationModelFactory {

  public Optional<ApplicationModel> create(String name, String muleConfigData) throws Exception {
    return loadConfigLines(org.apache.commons.io.IOUtils.toInputStream(muleConfigData)).map(configLine -> {
      try {
        final org.mule.runtime.config.spring.api.dsl.model.ApplicationModel applicationModel =
            loadApplicationModel(configLine);
        return new DefaultApplicationModel(name, applicationModel);
      } catch (Exception e) {
        throw new MuleRuntimeException(e);
      }
    });
  }
}
